<?php
require_once 'DBpdo/DBpdo.php';

class Model_user 

{


  function list_all_users($page,$search,$first_name,$last_name)
     {
        $db = connect();
        $q = 'SELECT * , t.ID_user as t_id, s.ID_user as s_id, user.ID_user as user_id FROM user 
                                  LEFT JOIN user_tutor  t ON  user.ID_user = t.ID_user
                                  LEFT JOIN user_student s ON  user.ID_user  = s.ID_user';

       $append ='';                           

       if(isset($search))
       {
         if($search=='Student')$type = 4;
         if($search=='Tutor')$type=2;
         if($search=='School Administrator')$type=7;
         $q .= " WHERE ID_type_user = '$type'";
         $append=' AND';

       }

       if(isset($first_name)) {

            empty($append)?$append=' WHERE ':$append=' AND ';
            $q.= $append." first_name LIKE '%$first_name%'";

       }

       if(isset($last_name)) {

         empty($append)?$append=' WHERE ':$append=' AND ';
          $q.= $append." last_name LIKE '%$last_name%'";

        
       }



        if($page)
         {
          $l = $page * 10 - 10;
          if($page == 1)
          {
             $l=0;  
          }
             $q_count = $q;
              $q .= " LIMIT {$l},10";
        }            
        else {
            $q_count = $q;
            $q .=' LIMIT 0, 10';
        }               
        $query = $db->prepare($q);
        $result['result'] = executePDO($query, 1);

        $stmt = $db->query($q_count);
        $row_count = $stmt->rowCount();


        $result['count'] = $query = $row_count;

        return $result;
       
       // return executePDO($query, 1);
    }


    function count_all_users()
    {

      $db = connect();
     $q="SELECT COUNT(*) FROM user";
     $query = $db->prepare($q);
     return executePDO($query, 1);

    }


   function count_tutors()

   {


     $db = connect();
     $q="SELECT COUNT(*) FROM user where ID_type_user = 2";
     $query = $db->prepare($q);
     return executePDO($query, 1);

   }


   function list_all_tutors()

   {

     $db = connect();
     $q="SELECT * FROM user where ID_type_user =4";
     $query = $db->prepare($q);
     return executePDO($query, 1);


 }


    function list_all_students()

   {

     $db = connect();
     $q="SELECT *, s.ID_user as student_id FROM user 
                       LEFT JOIN user_student s ON  user.ID_user  = s.ID_user
                       WHERE ID_type_user = 4";
     $query = $db->prepare($q);
     return executePDO($query, 1);


   }


   function list_students_by_group()
   {

    $db = connect();
    $req = Request::current();
    $group_id = $req->post('group_id');

    $q="SELECT * FROM groups_students where ID_groups = $group_id";
     $query = $db->prepare($q);
     return executePDO($query, 1);

   }
   
   function list_students_by_school()
   {

    $db = connect();
    $req = Request::current();
    $school_name = $req->post('school_name');
    $q = "SELECT * FROM user_student
                    LEFT JOIN user u ON user_student.ID_user = u.ID_user
                    WHERE current_school = '$school_name'";
     $query = $db->prepare($q);
     return executePDO($query, 1);

   }


   function list_all_schools()
   {

     $db = connect();
     $q="SELECT current_school FROM user_student GROUP BY current_school";
     $query = $db->prepare($q);
     return executePDO($query, 1);

   }





   function count_students()

   {

    $db = connect();
     $q="SELECT COUNT(*) FROM user where ID_type_user =4";
     $query = $db->prepare($q);
     return executePDO($query, 1);


   }


   function count_school_administrators()

   {

    $db = connect();
     $q="SELECT COUNT(*) FROM user where ID_type_user =7";
     $query = $db->prepare($q);
     return executePDO($query, 1);


   }
  


    function get_tutor_info($tutor_id)
    {
     
     $db = connect();

     $query = $db->prepare("SELECT * FROM user_tutor WHERE ID_user = $tutor_id");

     return executePDO($query, 1);

    }


  function get_user_by_ID()
  {
    $db = connect();
    $req = Request::current();
    $user_id = $req->post('user_id');
    $position = $_POST['user_position'];
     $query = $db->prepare("SELECT * FROM user WHERE ID_user = {$user_id} ");

      if($position == 'Student') {
      $query = $db->prepare("SELECT *, user.ID_user as student_id FROM user 
                             LEFT JOIN  user_student usd ON user.ID_user = usd.ID_user
                             LEFT JOIN  groups_students gs ON user.ID_user = gs.ID_user
                             LEFT JOIN  groups g ON  g.ID_groups = gs.ID_groups
                             WHERE user.ID_user = {$user_id} ");
      }



      if($position == 'Tutor') {
         $query = $db->prepare("SELECT * FROM user as us, user_tutor as ust WHERE us.ID_user = {$user_id} and ust.ID_user={$user_id}");
        }
   


      if($position=='School Administrator') {

             $query = $db->prepare("SELECT * FROM user as us, user_schooladmin as usad WHERE us.ID_user = {$user_id} and usad.ID_user={$user_id}");

       }


        return executePDO($query, 1);
  }


  function get_user_groups()

  {

    

    

  }


  function insert_user()
  {
    $db = connect();
    $req = Request::current();

     $image_base64 = $req->post('user_image_name');
    if(!empty($image_base64))
    {
       $split_entry =  explode(';', $image_base64);
       $get_extension = explode('/', $split_entry[0]);
       $img_extension = $get_extension[1];
   if($img_extension == 'png') 
   {   
       $img = str_replace('data:image/png;base64,', ' ', $image_base64);
    }  
   if($img_extension =='jpeg') 
   {
      $img = str_replace('data:image/jpeg;base64,', ' ', $image_base64);
   }
     if($img_extension =='jpg')
     {
       $img = str_replace('data:image/jpg;base64,', ' ', $image_base64);
     }
      $img_name = uniqid().'-'.uniqid().'-'.uniqid().'.'.$img_extension;
      $entry = base64_decode($img);
      file_put_contents('assets/images/'.$img_name, $entry);
    //  $image = imagecreatefromstring($entry);
    }


    if(empty($img_name)) $img_name = 'user.png';

 
     if($_POST['position'][0]=='Student') {

      $position = 4;
     }

     if($_POST['position'][0]=='Tutor') {

      $position = 2;
     }

     if($_POST['position'][0]=='School Administrator') {

      $position = 7;
     }



      $query_add_user = $db->prepare(" INSERT INTO user (ID_type_user,first_name, last_name, user_name, email, photoURL, positions) VALUES (:ID_type_user,:first_name, :last_name, :user_name, :email, :image_name, :positions) ");
       $query_add_user->execute(array(':first_name'=> $req->post('first_name'),
       ':ID_type_user'=> $position,
       ':last_name'=> $req->post('last_name'),
       ':user_name'=>$req->post('user_name'),
       ':email'=>$req->post('email'),
       ':image_name'=>$img_name,
       ':positions'=> $_POST['position'][0]));
       $lastId = $db->lastInsertId(); 


  if($position == 4) {
      $query_add_student = $db->prepare(" INSERT INTO user_student (ID_user, grade ,address, city, country, parent_name,parent_email, phone, current_school,state,zip_code) VALUES (:ID_user, :grade, :address, :city, :country, :parent_name,:parent_email, :phone, :current_school,:state,:zip_code) ");
       $query_add_student->execute(array(':ID_user'=> $lastId,
       ':grade'=>$req->post('grade'),
       ':address'=>$req->post('address'),
       ':city'=>$req->post('city'),
       'state'=>$req->post('state'),
       'zip_code'=>$req->post('zip_code'),
       ':country'=>$req->post('country'),
       ':parent_name'=>$req->post('parent_name'),
       ':parent_email'=>$req->post('parent_email'),
       ':phone'=>$req->post('phone'),
       ':current_school'=>$req->post('current_school')

       ));
       echo 'Student Added';
    }
    if($position == 2) {
      $query_add_student = $db->prepare(" INSERT INTO user_tutor (ID_user,location,university,subject) VALUES (:ID_user, :location, :university, :subject) ");
       $query_add_student->execute(array(':ID_user'=> $lastId,
       ':location'=>$req->post('tut_location'),
       ':university'=>$req->post('university'),
       ':subject'=>$req->post('subject')
      ));
       echo 'Tutor Added';
    }
    if($position == 7) {
      
      $query_add_school_admin = $db->prepare(" INSERT INTO user_schooladmin (ID_user,school) VALUES (:ID_user, :school) ");
       $query_add_school_admin->execute(array(':ID_user'=> $lastId,
       ':school'=>$req->post('admin_school'),
    
      ));
    }
}
  function remove_user()
  {
    $db = connect();
    $req = Request::current();
    $remove_user  = $req->post('user_id');
    $position = $req->post('user_position');
    $delete_query = $db->prepare("DELETE FROM user WHERE ID_user = {$remove_user}");
    $delete_query->execute();
      if($position == 'Student')
    {
    $delete_student_query = $db->prepare("DELETE FROM user_student WHERE ID_user = {$remove_user}");
    $delete_student_query->execute();
    }     
      if($position == 'Tutor')
    {
    $delete_tutor_query = $db->prepare("DELETE FROM user_tutor WHERE ID_user = {$remove_user}");
    $delete_tutor_query->execute();
    }   
      if($position == 'School Administrator') {

    $delete_school_admib = $db->prepare("DELETE FROM user_schooladmin WHERE ID_user = {$remove_user}");
    $delete_school_admib->execute();

      }

     
    $delete_user_group = $db->prepare("DELETE FROM groups_students WHERE ID_user = {$remove_user}");
    $delete_user_group->execute();




  }
  function insert_user_photo()
  {
      $db = connect();
      $req = Request::current();
      $path = "assets/images/";
      $valid_formats = array("jpg", "png", "gif", "bmp","jpeg");
      if(isset($_POST) and $_SERVER['REQUEST_METHOD'] == "POST")
      {
      $name = $_FILES['photoimg']['name'];
      $size = $_FILES['photoimg']['size'];
      if(!empty($_FILES['photoimg'])) {
      if(strlen($name))
      {
      list($txt, $ext) = explode(".", $name);
      if(in_array($ext,$valid_formats))
      {
      if($size<(1024*1024)) // Image size max 1 MB
      {
      $actual_image_name = time().".".$ext;
      $tmp = $_FILES['photoimg']['tmp_name'];
       if(Image::factory($tmp) ->resize(200, 200, Image::AUTO)->save($path.$actual_image_name))
      //if(move_uploaded_file($tmp, $path.$actual_image_name))
      {
    /*
                    $query = $db->prepare(" INSERT INTO user (photoURL) VALUES (:actual_image_name) ");
             $execute =  $query->execute(array(':actual_image_name'=>$actual_image_name));
            */
           echo $actual_image_name;
      }
      else
      echo "failed";
      }
      else
      echo "Image file size max 1 MB"; 
      }
      else
      echo "Invalid file format.."; 
      }
      else
      echo "Please select image..!";
      exit;
      }
}
  }


  function update_user()
  {
    $db = connect();
    $req = Request::current();
    $user_id = $req->post('user_id');
    $user_name = $req->post('user_name');
    $first_name = $req->post('first_name');
    $last_name = $req->post('last_name');
    $user_name = $req->post('user_name');
    $user_image = $req->post('user_image_name');
    $position = $req->post('position');
    $group = $req->post('group');
    //Student Fields//
    $address = $req->post('address');
    $city = $req->post('city');
    $state = $req->post('state');
    $zip_code= $req->post('zip_code');
    $country = $req->post('country');
    $parent_email = $req->post('parent_email');
    $parent_name = $req->post('parent_name');
    $grade  = $req->post('grade');
    $phone = $req->post('phone');
    $current_school = $req->post('current_school');
    //Tutor Fields//
    $location = $req->post('ins_location');
    $university= $req->post('university');
    $subject = $req->post('subject');
    //School Administrator Fields
    $admin_school = $req->post('admin_school');

   $update_query = $db->prepare("UPDATE user SET user_name=?, first_name=?, last_name=?, photoURL=?, positions=? WHERE ID_user=?");
    if($update_query->execute(array($user_name,$first_name,$last_name,$user_image,$position[0],$user_id)))
   {
     echo 'update ok';
     echo  $group;
   }
  if($position[0] == 'Student')
  {
   
   $update_query = $db->prepare("UPDATE user_student SET address=?, city=?, country=?, parent_name=?, parent_email=?, grade=?, phone=?, current_school=?, state =?, zip_code = ? WHERE ID_user=?");
    if($update_query->execute(array($address,$city,$country, $parent_name,$parent_email,$grade,$phone, $current_school,$state,$zip_code,$user_id)))
   {

   }
  }


  if($position[0]=='Tutor')
  {

   $update_query = $db->prepare("UPDATE user_tutor SET location=?, university=?, subject=? WHERE ID_user=?");

       if($update_query->execute(array($location,$university,$subject,$user_id)))
   {

   }
  }
   if($position[0]=='School Administrator')
  {

   $update_query = $db->prepare("UPDATE user_schooladmin SET school=? WHERE ID_user=?");

       if($update_query->execute(array($admin_school,$user_id)))
   {

   }
  }
   //groups///
if(isset($group)) 
{
     $query_add_student = $db->prepare(" INSERT INTO groups_students (ID_groups, ID_user) VALUES (:ID_groups ,:ID_user) ");
   $check_group = $db->prepare("SELECT * FROM groups_students WHERE ID_groups= $group and ID_user = $user_id");
   $run_check = executePDO($check_group,1);
   if(empty($run_check))
   {
    $query_add_student->execute(array(
      ':ID_groups'=> $group,
      ':ID_user'=> $user_id
    ));
   }
}
    

 }
    function list_journal($ID_group_schedule) {
        $db = connect();
        $query = $db->prepare('CALL z_sel_groups_students_module_journal(?)');
        $query->bindParam(1, $ID_group_schedule);
        return executePDO($query, 1);
    }
    function update_student_attendance() {



        $db = connect();
        $req = Request::current();
        $group_id = $req->post('group_id');
        $student_id = $req->post('student_id');
        $module_id = $req->post('module_id');
        $start_date = $req->post('start_date');
        $attendance= $req->post('attendance');


        $get_att_table =  $db->prepare("SELECT * FROM groups_schedule WHERE ID_groups= $group_id and ID_course_module = $module_id");
      $att = executePDO($get_att_table ,1);

      $schedule_id = $att[0]['ID_groups_schedule'];

    



       $check_att = $db->prepare("SELECT * FROM groups_students_module WHERE ID_groups_schedule= $schedule_id and ID_user = $student_id");
   $run_check = executePDO($check_att,1);
  

   if(empty($run_check))
   {
       $query_add_student = $db->prepare(" INSERT INTO groups_students_module (ID_groups_schedule, ID_user, attendance, attendance_timestamp ) VALUES (:ID_groups_schedule,:ID_user, :attendance,:attendance_timestamp) ");
       $query_add_student->execute(array(
        ':ID_groups_schedule'=>$schedule_id,
        ':ID_user'=> $student_id,
        ':attendance'=>$attendance,
        ':attendance_timestamp'=>$start_date
       ));
   }

   else {


   $update_query = $db->prepare("UPDATE groups_students_module SET attendance=?WHERE ID_user=? and ID_groups_schedule=?");

  $update_query->execute(array($attendance,$student_id,$schedule_id));

   }


    
    }
    function update_student_homework() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $ID_groups_schedule = $current->post('ID_groups_schedule');
        $ID_type_marks = $current->post('selected');
        $db = connect();
        $query = $db->prepare('CALL z_upd_student_module_homework(?,?,?)');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $ID_groups_schedule);
        $query->bindParam(3, $ID_type_marks);
        executePDO($query, 0);
        print_r('Updated');
    }
    function update_student_testscore() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $ID_groups_schedule = $current->post('ID_groups_schedule');
        $test_score = $current->post('test_score');
        $db = connect();
        $query = $db->prepare('CALL z_upd_student_module_test(?,?,?)');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $ID_groups_schedule);
        $query->bindParam(3, $test_score);
        executePDO($query, 0);
        print_r('Updated');
    }
    /////////////////////////////////////////////////////////////////////////////////
    function student_course_review($p_ID_user_student, $p_ID_groups) {
        $db = connect();
//        $query = $db->prepare('CALL z_sel_groups_students_course_journal(?, ?)');
//        $query->bindParam(1, $p_ID_user_student);
//        $query->bindParam(2, $p_ID_course); 
        $query = $db->prepare('select groups_students.test_one,
       groups_students.test_two,
       groups_students.test_three,
       groups_students.test_one_pdf,
       groups_students.test_two_pdf,
       groups_students.test_three_pdf
                         from   groups_students
                         where  groups_students.ID_user=? and groups_students.ID_groups=? ;');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_groups);
        $data[0] = executePDO($query, 1);
        $query = $db->prepare('select groups.ID_course,
       course.name as course_name,
       groups.name as group_name,
       groups_schedule.ID_course_module,
       course_module.name as module_name,
       groups_schedule.ID_groups_schedule,
       groups_schedule.date_time,
       user.ID_user,
       user.first_name,
       user.last_name,
       user.photoURL,
       groups_students_module.attendance,
       groups_students_module.attendance_timestamp,
       groups_students_module.ID_type_marks
                         from   groups_students_module  inner join user on user.ID_user=groups_students_module.ID_user
                      inner join user_student on user_student.ID_user=user.ID_user   
                      inner join groups_schedule on groups_schedule.ID_groups_schedule=groups_students_module.ID_groups_schedule
                      inner join course_module on course_module.ID_course_module=groups_schedule.ID_course_module
                      inner join course on course.ID_course=course_module.ID_course
                      inner join groups on groups_schedule.ID_groups=groups.ID_groups
                         where  groups_students_module.ID_user=? and groups.ID_groups=?;');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_groups);
        $data[1] = executePDO($query, 1);
        return $data;
    }
    function spreadsheet_student($p_ID_user_student, $p_ID_course) {
        $db = connect();
        $query = $db->prepare('CALL z_sel_student_spreadsheet_by_course(?, ?)');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_course);
        return executePDO($query, 4);
    }
    function spreadsheet_admin($p_ID_groups) {
        $db = connect();
//        $query = $db->prepare('CALL z_sel_admin_spreadsheet_by_course(?)');
//        $query->bindParam(1, $p_ID_course);
//        return executePDO($query, 4);
        $query = $db->prepare('select groups.ID_groups,
                                      location.name as location_name,
                                      course.name as course_name,
                                      groups.name as group_name
                               from   groups inner join course on course.ID_course=groups.ID_course
                                             inner join location on location.ID_location=groups.ID_location
                               where  groups.ID_groups=?;');
        $query->bindParam(1, $p_ID_groups);
        $data[0] = executePDO($query, 1);
        $query = $db->prepare('select count(groups_schedule.ID_groups_schedule) as count_classes
                               from   groups_schedule
                               where  groups_schedule.ID_groups=?;');
        $query->bindParam(1, $p_ID_groups);
        $data[1] = executePDO($query, 1);
        $query = $db->prepare('select groups_schedule.ID_groups AS ID_groups, 
                                      groups_students_module.ID_user AS ID_user, 
                                      sum(groups_students_module.attendance) AS attendance, 
                                      sum(type_marks.points) AS marks
                               from   groups_schedule inner join groups_students_module ON groups_students_module.ID_groups_schedule = groups_schedule.ID_groups_schedule
                    inner join type_marks ON groups_students_module.ID_type_marks = type_marks.ID_type_mark
                               where groups_schedule.ID_groups = ?
                               group by groups_students_module.ID_user
                               order by groups_students_module.ID_user;');
        $query->bindParam(1, $p_ID_groups);
        $data[2] = executePDO($query, 1);
        $query = $db->prepare('select groups_students.ID_groups AS ID_groups,
                                      user.first_name,
                                      user.last_name,
                                      user.photoURL, 
                                      groups_students.test_one AS test_one, 
                                      groups_students.test_two AS test_two, 
                                      groups_students.test_three AS test_three,
                                      groups_students.test_one_pdf,
                                      groups_students.test_two_pdf,
                                      groups_students.test_three_pdf
                               from   groups_students inner join user on user.ID_user=groups_students.ID_user
                               where  groups_students.ID_groups = ?;');
        $query->bindParam(1, $p_ID_groups);
        $data[3] = executePDO($query, 1);
        return $data;
    }
    function find_school() {
        $current = Request::current();
        $par = $current->post('search');
        $par = trim($par);
        $name_or_zip = 'zip';
        if (strlen($par) == 5) {
            for ($i = 0; $i < 5; $i++) {
                if (!is_numeric($par[$i])) {
                    $name_or_zip = 'name';
                    break;
                }
            }
        } else {
            $name_or_zip = 'name';
        }
        $sql = '';
        if ($name_or_zip == 'zip') {
            $sql = 'select location.ID_location,
                           type_location.name as type,
                           location.name, 
                           location.address,
                           location.county,
                           location.zip_code
                    from   location inner join type_location on type_location.ID_type_location=location.ID_type_location
                    where  location.ID_location>20 and location.zip_code like ("' . $par . '");';
        } else {
            $del = ' ';
            $arr = explode($del, $par);
            $bool = true;
            $sql = 'select location.ID_location,
                           type_location.name as type,
                           location.name, 
                           location.address,
                           location.county,
                           location.zip_code
                    from   location inner join type_location on type_location.ID_type_location=location.ID_type_location
                    where  location.ID_location>20 and (';
            foreach ($arr as $value) {
                if ($bool) {
                    $sql = $sql . ' location.name like ("%' . $value . '%")';
                    $bool = false;
                } else {
                    $sql = $sql . ' or location.name like ("%' . $value . '%")';
                }
            }
            $sql = $sql . ');';
        }
        $db = connect();
        $query = $db->prepare($sql);
        return executePDO($query, 1);
    }
    function find_tutor() {
        $current = Request::current();
        $subject_search = strtolower($current->post('subject'));
        $location_search = strtolower($current->post('location'));
        $db = connect();
        $query = $db->prepare('select ID_user, location, subject from user_tutor;');
        $arr = executePDO($query, 1);
        $sql = 'select user.ID_user,
                       user.first_name,
                       user.last_name,
                       user_tutor.university,
                       user_tutor.location,
                       user_tutor.subject
                from   user inner join user_tutor on user_tutor.ID_user=user.ID_user
                where  user.ID_user in (';
        $where = '';
        $dont_add_coma = true;
        foreach ($arr as $value) {
            $subject = strtolower($value['subject']);
            if (strlen($subject_search) > 0) {
                if (strpos($subject, $subject_search) !== false) {
                    if ($dont_add_coma) {
                        $where = $where . $value['ID_user'];
                        $dont_add_coma = false;
                    } else {
                        $where = $where . ',' . $value['ID_user'];
                    }
                }
            }
            $subject = strtolower($value['location']);
            if (strlen($location_search) > 0) {
                if (strpos($subject, $location_search) !== false) {
                    if ($dont_add_coma) {
                        $where = $where . $value['ID_user'];
                        $dont_add_coma = false;
                    } else {
                        $where = $where . ',' . $value['ID_user'];
                    }
                }
            }
        }
        $sql = $sql . $where . ');';
        if (strlen($where) > 0) {
            $query = $db->prepare($sql);
            $arr = executePDO($query, 1);
            $data = $arr;
            return $data;
        } else {
            $data[0]['first_name'] = 'not found';
            return $data;
        }
    }
    /////////////    cms    /////////////////////////
    /////////tutor////////
    function insert_tutor() {
        $current = Request::current();
        $user_name = $current->post('user_name');
        $first_name = $current->post('first_name');
        $last_name = $current->post('last_name');
        $photoURL = $current->post('photoURL');
        $location = $current->post('location');
        $university = $current->post('university');
        $subject = $current->post('subject');
        $about = $current->post('about');
        $db = connect();
        $query = $db->prepare('call z_cms_ins_tutor (?, ?, ?, ?, ?, ?, ?, ?);');
        $query->bindParam(1, $user_name);
        $query->bindParam(2, $first_name);
        $query->bindParam(3, $last_name);
        $query->bindParam(4, $photoURL);
        $query->bindParam(5, $location);
        $query->bindParam(6, $university);
        $query->bindParam(7, $subject);
        $query->bindParam(8, $about);
        return executePDO($query, 1);
    }
    function tutor_combo() {
        $db = connect();
        $query = $db->prepare('call z_cms_combo_tutor_all ();');
        $query->bindParam(1, $ID_user);
        return executePDO($query, 1);
    }
    function select_tutor($ID_user) {
        $db = connect();
        $query = $db->prepare('call z_cms_sel_tutor (?);');
        $query->bindParam(1, $ID_user);
        return executePDO($query, 1);
    }
    function update_tutor() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $user_name = $current->post('user_name');
        $first_name = $current->post('first_name');
        $last_name = $current->post('last_name');
        $photoURL = $current->post('photoURL');
        $location = $current->post('location');
        $university = $current->post('university');
        $subject = $current->post('subject');
        $about = $current->post('about');
        $db = connect();
        $query = $db->prepare('call z_cms_upd_tutor (?, ?, ?, ?, ?, ?, ?, ?, ?);');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $user_name);
        $query->bindParam(3, $first_name);
        $query->bindParam(4, $last_name);
        $query->bindParam(5, $photoURL);
        $query->bindParam(6, $location);
        $query->bindParam(7, $university);
        $query->bindParam(8, $subject);
        $query->bindParam(9, $about);
        return executePDO($query, 1);
    }
    /////////tutor////////
}
