<?php



require "pdoconfig.php";



function connect() {

    $conn_error = 'Connection failed';

    $config = config();

    $connection = $config[0];

    $user = $config[1];

    $password = $config[2];

    try {

        $conn = new PDO($connection, $user, $password, array(PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8'));

        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        return $conn;

    } catch (PDOException $pe) {

        die("Error: " . $conn_error);

    }

}



function executePDO($query, $rows = 1) {

    $query->execute();

    $result = array();

    if ($rows == 1) {

        $result = $query->fetchAll(PDO::FETCH_ASSOC);

    } else {

        for ($i = 0; $i < $rows; $i++) {

            $result[$i] = $query->fetchAll(PDO::FETCH_ASSOC);

            $query->nextRowset();

        }

    }

    return $result;

}

function getData($q){
    $db = connect();
    $query = $db->prepare($q);
    return executePDO($query, 1);
}

function setData($q){
    $db = connect();
    $query = $db->prepare($q);
    return $query->execute();
}