<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Front_Ajax extends Kohana_Controller {

    public function action_passChange() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
        
        $student = ORM::factory('AuthUser')->where('ID_user', '=', Auth::instance()->get_user()->ID_user)->find();
        $student->password = $this->request->post('data');
        $student->update();
        
        return true;
    }
    
    public function action_schoolChange() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
        
       $schools = Model::factory('Front_Register')->getSchools($this->request->post('data'));
       
       foreach($schools as $school){
           echo '<option>'.$school['name'].'</option>';
       }
    }
    
    public function action_profileChange() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
            
            $posty = $this->request->post('data');
            $data = array();
            foreach ($posty as $input){
               if($input['value']=='on') $input['value'] = 1;
               if($input['value']=='off') $input['value'] = 0;
                $data[trim($input['name'])]=HTML::chars($input[trim('value')]);
            }
            //$data['birth_date'] = DateTime::createFromFormat('F jS, Y', $data['birth_date'])->format('Y-m-d');
            $query = Model::factory('Front_Student')->updateStudentData($data);  
            
        return true;
    }
    
    public function action_profileRegister() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
            
            $posty = $this->request->post('data');
            $data = array();
            foreach ($posty as $input){
               if($input['value']=='on') $input['value'] = 1;
               if($input['value']=='off') $input['value'] = 0;
                $data[trim($input['name'])]=HTML::chars($input[trim('value')]);
            }
            //$data['birth_date'] = DateTime::createFromFormat('F jS, Y', $data['birth_date'])->format('Y-m-d');
            
            $parentPassword = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') , 0 , 8 );
            $query = Model::factory('Front_Register')->registerStudent($data, $parentPassword);
            
            $this->emailSender($data, $parentPassword);
            
        return $query;
    }


    // Check if student email address enterred in registration form already exists in database 
    public function action_checkEmail() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
        
        $user = ORM::factory('AuthUser')
                ->where('email', '=', $this->request->post('email'))
                ->and_where('ID_user', '<>', $this->getUserId())
                ->count_all();
        
        if($user > 0){
            echo json_encode("E-mail address already exists.");
        } else {
            echo json_encode("true");
        }
    }
    
    // Check if parent email address enterred in registration form already exists in database 
    public function action_checkEmailParent() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
        
        $user = ORM::factory('AuthUser')
                ->where('email', '=', $this->request->post('parentEmail'))
                ->and_where('ID_user', '<>', $this->getUserId())
                ->count_all();
        
        if($user > 0){
            echo json_encode("E-mail address already exists.");
        } else {
            echo json_encode("true");
        }
    }
    public function action_checkEmailProfileParent() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
        
        $user = ORM::factory('AuthUser')
                ->where('email', '=', $this->request->post('email'))
                ->and_where('ID_user', '<>', $this->getUserId())
                ->count_all();
        if($user > 0){
            echo json_encode("E-mail address already exists.");
        } else {
            echo json_encode("true");
        }
    }
    public function action_profileUpdateProfileParent() {
        if(!$this->request->is_ajax()) {return FALSE; die();}
            
            $posty = $this->request->post('data');
            $data = array();
            foreach ($posty as $input){
               if($input['value']=='on') $input['value'] = 1;
               if($input['value']=='off') $input['value'] = 0;
                $data[trim($input['name'])]=HTML::chars($input[trim('value')]);
            }
            
            //$data['birth_date'] = DateTime::createFromFormat('F jS, Y', $data['birth_date'])->format('Y-m-d');
            $query = Model::factory('Front_Student')->updateParentData($data);  
            
        return true;
    }
    // Check if user name enterred in registration form already exists in database 
    public function action_checkUsername() {
        
        if(!$this->request->is_ajax()) {return FALSE; die();}
          
        $user = ORM::factory('AuthUser')
                ->where('user_name', '=', $this->request->post('user_name'))
                ->and_where('ID_user', '<>', $this->getUserId())
                ->count_all();
        
        if($user > 0){
            echo json_encode("Username already exists.");
        } else {
            echo json_encode("true");
        }
    }
    
    public function action_imageChange(){
        
        
      if ($this->request->method() == Request::POST)
        {
        if (isset($_FILES['studentPhoto']))
            {                 
                $filename = $this->_save_image($_FILES['studentPhoto']);
                echo $filename;
            }
        }
        
    }
    
    protected function _save_image($image)
    {   
        if (
            ! Upload::valid($image) OR
            ! Upload::not_empty($image) OR
            ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif')))
        {
            return FALSE;
        }
        
        $directory = DOCROOT.'assets/images/';
        
        if ($file = Upload::save($image, NULL, $directory))
        {
            $filename = strtolower(Text::random('alnum', 20)).'.jpg';
            
            $size = getimagesize($file);
            if($size[0]>$size[1]) {
                $y = 240; $x = NULL;
            } else { $x = 240; $y = NULL; }
            
            Image::factory($file)
                ->resize($x, $y, Image::AUTO)
                ->crop(240, 240)
                ->save($directory.$filename);
 
            // Delete the temporary file
            unlink($file);
 
            return $filename;
        }
 
        return FALSE;
    }
    
    protected function emailSender($data, $parentPassword){
        
        $message_content = wordwrap("\nDear parent,\nWe just receive registration form of student".$data['first_name']." ".$data['last_name']."\n\nYou can login to portal using next data:\n\nUsername: ".$data['parentEmail']."\n\nPassword: ".$parentPassword."\n\nE-mail generated by PHP Swiftmailer 5.1.0 - The Ivy Key", 70, "\n");

        $email = Email::factory('The Ivy Key - Registration info', $message_content)
                 ->to(HTML::chars($data['parentEmail']))
                 ->from('info@theivykey.com', 'The Ivy Key Portal')
                 ->send();
        
    }
    
    protected function getUserId(){
        if(Auth::instance()->get_user()) {
            return Auth::instance()->get_user()->ID_user;
        } else {
            return 0;
        }
    }
}