<style>
    form input, form select {
        width: 100%;
    }
    form input[type=submit] {
        width: 6vw;
        margin-top: 2vw;
    }
</style>

<nav class="uk-navbar uk-navbar-attached" data-uk-sticky data-uk-scrollspy-nav="{closest:'li'}" >
    <ul class="uk-navbar-nav">
        
        <?php foreach($courses as $course): ?>
            
        <li>
            <a href="<?php echo URL::base().'Cms/Programs/index/'.$course->ID_course;?>">
                <div class="uk-icon-calendar top-menu-icon"></div>
                <?php echo $course->name; ?>
            </a>
        </li>
        <?php endforeach; ?>
        
    </ul>
</nav>

<div class="uk-grid cms-page-content">
    <div class="uk-width-1-1 page-title">
        <p>Edit Program</p>
        <a class="uk-button uk-button-danger" onclick="return confirmDelete();" href="<?php echo URL::base().'Cms/Programs/delete/'.$program->ID_programs;?>"><div class="uk-icon-minus-square top-menu-icon"></div>Delete program</a>
        <br/><br/><hr/>
    </div>
    
    <div class="uk-width-1-1 uk-margin-top">
        <form class="uk-form uk-form-stacked" onsubmit="" action="../edit" method="POST">
            <div class="uk-form-row uk-width-1-6">
                    <label class="uk-form-label" for="course_type">Course type<div class="req-label">Required</div></label>
                    <div class="uk-button-dropdown">
                        <select name="course_type">
                            <?php 
                            foreach ($courses as $type) {
                                echo '<option value="'.$type->ID_course.'"';
                                echo ($type->ID_course == $program->ID_course) ? ' selected' : '';
                                echo '>'.$type->name.'</option>';
                            }
                            ?>
                        </select>
                    </div>
            </div>
            
            <div class="uk-form-row uk-width-1-6">
                    <label class="uk-form-label" for="program_type">Program type<div class="req-label">Required</div></label>
                    <div class="uk-button-dropdown">
                        <select name="program_type">
                            <?php 
                            foreach ($program_type as $type) {
                                echo '<option value="'.$type->ID_program_type.'"';
                                echo ($type->ID_program_type == $program->ID_program_type) ? ' selected' : '';
                                echo '>'.$type->type.'</option>';
                            }
                            ?>
                        </select>
                    </div>
            </div>
            
            <div class="uk-form-row uk-width-4-6">
                    <label class="uk-form-label" for="school">School<div class="req-label">Required</div></label>
                    <div class="uk-button-dropdown">
                        <select name="school">
                            <?php 
                            foreach ($schools as $type) {
                                echo '<option value="'.$type->ID_location.'"';
                                echo ($type->ID_location == $program->ID_location) ? ' selected' : '';
                                echo '>'.$type->name.', '.$type->address.', '.$type->zip_code.'</option>';
                            }
                            ?>
                        </select>
                    </div>
            </div>
            
            <div class="uk-form-row uk-width-1-6">
                    <label class="uk-form-label" for="tutor">Tutor<div class="req-label">Required</div></label>
                    <div class="uk-button-dropdown">
                        <select name="tutor">
                            <?php 
                            foreach ($tutors as $tutor) {
                                echo '<option value="'.$tutor->ID_user.'"';
                                echo ($tutor->ID_user == $program->ID_user) ? ' selected' : '';
                                echo '>'.$tutor->first_name.' '.$tutor->last_name.'</option>';
                            }
                            ?>
                        </select>
                    </div>
            </div>
            
            <div class="uk-form-row uk-width-1-6">
                    <label class="uk-form-label" for="start_date">Start date<div class="req-label">Required</div></label>
                    <input type="text" name="start_date" data-uk-datepicker="{format:'MMMM Do, YYYY'}" value="<?php echo date_format(new DateTime($program->start_date), "F d, Y");?>">
            </div>
            
            <div class="uk-form-row uk-width-2-6">
                    <label class="uk-form-label" for="for_exam">Prep for exam<div class="req-label">Required</div></label>
                    <input type="text" name="for_exam" value="<?php echo $program->for_exam;?>">
            </div>
            
            <div class="uk-form-row uk-width-3-6">
                    <label class="uk-form-label" for="meets_on">Meets on<div class="req-label">Required</div></label>
                    <input type="text" name="meets_on" value="<?php echo $program->meets_on;?>">
            </div>
            <div class="uk-form-row uk-width-1-10">
                    <label class="uk-form-label" for="price">Price<div class="req-label">Required</div></label>
                    <input type="text" name="price" onkeypress="return allowNum(event)" value="<?php echo $program->price;?>">
            </div>
            
            <div class="uk-form-row uk-width-1-10">
                        <input type="submit" class="uk-button" value="Update">
            </div>
            <input type="hidden" name="ID_programs" value="<?php echo $program_id;?>">
        </form>
    </div>
    
    
    
    <script>
        function confirmDelete(){
            return confirm('If you delete program, schedule for this program will be deleted also! Are you sure?')
        }
    </script>
</div>
<script>
    function allowNum(event) {
    var key = window.event ? event.keyCode : event.which;

if (event.keyCode == 8 || event.keyCode == 46
 || event.keyCode == 37 || event.keyCode == 39) {
    return true;
}
else if ( key < 48 || key > 57 ) {
    return false;
}
else return true;
};
    </script>
