<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Search extends Controller_IvyTemplate {

    public function action_index() {
        
        $tutors_data = ORM::factory('Cms_Tutors')->where('ID_user', '=', $this->request->param('id'))->find();

        $this->template->title .= " - Search Results";
        $this->template->content = View::factory('search_view');
        $this->template->content->data = $tutors_data;
    }

    public function action_tutors_by_subject(){

        $test_model = Model::factory('users');
        $data = $test_model->find_tutor();
        if ($data[0]['first_name'] != 'not found') {
            $this->template->content = View::factory('search_view')
                    ->set('data', $data)->set('search_title', 'Search results - Tutors by subject');
        } else {
            Http::redirect('Tutors');
        }
        $this->template->title .= " - Tutors by Subject Search Results";
    }
    
    public function action_find_program(){
        $test_model = Model::factory('users');
        $data = $test_model->find_program();
        $this->template->content = View::factory('search_program_view')->set('search_title', 'Search results - Find Program')
                ->set('data', $data);
    }

    public function action_find_school() {
        $test_model = Model::factory('user');
        $data = $test_model->find_school();
        $this->template->content = View::factory('search_school_view')->set('search_title', 'Search results - Find school')
                ->set('data', $data);
    }

}
