<?php

defined('SYSPATH') or die('No direct script access.');

class Controller_Login extends Controller_IvyTemplate {

    public function action_index() {

        $this->template->content = View::factory('user/info')
                ->bind('user', $user);

        // Load the user information
        $user = Auth::instance()->get_user();

        // if a user is not logged in, redirect to login page
        if (!$user) {
            Request::current()->redirect('Login/login');
        }
    }

    public function action_create() {
        $this->template->content = View::factory('user/create')
                ->bind('errors', $errors)
                ->bind('message', $message);

        if (HTTP_Request::POST == $this->request->method()) {
            try {

                // Create the user using form values
                $user = ORM::factory('user')->create_user($this->request->post(), array(
                    'username',
                    'password',
                    'email'
                ));

                // Grant user login role
                $user->add('roles', ORM::factory('role', array('name' => 'login')));

                // Reset values so form is not sticky
                $_POST = array();

                // Set success message
                $message = "You have added user '{$user->username}' to the database";
            } catch (ORM_Validation_Exception $e) {

                // Set failure message
                $message = 'There were errors, please see form below.';

                // Set errors using custom messages
                $errors = $e->errors('models');
            }
        }
    }

    public function action_login() {

        if (HTTP_Request::POST == $this->request->method()) {
            // Attempt to login user
            $remember = array_key_exists('remember', $this->request->post()) ? (bool) $this->request->post('remember') : FALSE;
            $user = Auth::instance()->login($this->request->post('usrname'), $this->request->post('paswd'), $remember);

            // If successful, redirect user
            if ($user) {
                $session = Session::instance();
                $session->set('username', $this->request->post('usrname'));

                //$this->redirect('Cms');
                $this->response->body("Logged");
            }
        }
    }

    public function action_logout() {
        // Log user out
        Auth::instance()->logout();
        Session::instance()->destroy();
        // Redirect to home page
        $this->redirect('home');
    }

    public function action_checkUser() {

        if (strpos(Request::initial()->referrer(), 'Cms') !== false) {
            $sid = $this->saveUser();
            session_destroy();
            $this->redirect(URL::base(true, true) . 'ivykeyportal/Login/login/' . $sid);
        } else {
        
        if (Auth::instance()->logged_in(array('admin', 'moderator'))){
            $this->redirect('Cms');
        } else {
            $sid = $this->saveUser();
            session_destroy();
            $this->redirect(URL::base(true, true) . 'ivykeyportal/Login/login/' . $sid);
        }
        }
    }

    protected function saveUser() {

        $ssid = Session::instance()->id();
        $un = Session::instance()->get('username');
        $ps = Auth::instance()->password($un);
        $role = Auth::instance()->get_user($un)->ID_type_user;

        $save = ORM::factory('Logged');
        $save->session_id = $ssid;
        $save->username = $un;
        $save->password = $ps;
        $save->role = $role;
        $save->save();

        return $ssid;
    }

    public function action_portal() {
        if (Auth::instance()->logged_in(array('admin', 'moderator'))) {
            
        }
    }

}