<?php defined('SYSPATH') or die('No direct script access.');

class Controller_CmsTemplate extends Controller_Template
{

    public $template = 'templates/cmstemplate';

    public function before()
    {   
        if ( !Auth::instance()->logged_in(array('admin', 'moderator'))){
            $this->redirect("home");
        }
        parent::before();
        
        $this->session = Session::instance();
        
         $action_name = Request::initial()->action();
        
        if ($this->auto_render)
        {
            // Initialize empty values
            $this->template->title   = 'The Ivy Key';
            $this->template->content = '';

            $logo_url = ORM::factory('home')->where('name', '=', 'logo_image')->find();
            $contact = ORM::factory('home')->where('name', '=', 'phone_number')->find();
            $login = ORM::factory('home')->where('name', '=', 'login')->find();
            $menu = ORM::factory('home')->where('belongs_to', '=', 'header')->where('identifier', '=', 'menu')->find_all();

            $soc_links = ORM::factory('home')->where('belongs_to', '=', 'footer')->where('identifier','=','soc_links')->find_all();
            $our_team = ORM::factory('home')->where('belongs_to', '=', 'footer')->where('identifier','=','our_team')->find_all();
            $our_programs = ORM::factory('home')->where('belongs_to', '=', 'footer')->where('identifier','=','our_programs')->find_all();
            $the_ivy_key = ORM::factory('home')->where('belongs_to', '=', 'footer')->where('identifier','=','the_ivy_key')->find_all();

            $this->template->footer = View::factory('templates/cms_footer');
            $this->template->footer->soc_links = $soc_links;
            $this->template->footer->our_team = $our_team;
            $this->template->footer->our_programs = $our_programs;
            $this->template->footer->the_ivy_key = $the_ivy_key;

            $view_head = View::factory('templates/cms_header');
            $view_head->logo_url = $logo_url;
            $view_head->contact = $contact;
            $view_head->login = $login;
            $view_head->menu = $menu;
            $this->template->header = $view_head;

            $this->template->styles = array();
            $this->template->scripts = array();

        }
    }

    public function after()
    {
        if ($this->auto_render)
        {
            $styles = array(
                'assets/css/cms_style.css',
                'assets/css/sn-grid.css',
                'assets/css/jquery-ui.min.css',
                'assets/css/imgareaselect-default.css',
                'assets/uikit/css/uikit.gradient.css',
                'assets/uikit/css/addons/uikit.addons.min.css',
                'assets/css/layerslider.css',
                'http://fonts.googleapis.com/css?family=Open+Sans:300,300italic,400,600,700',
                'http://fonts.googleapis.com/css?family=Playfair+Display:400,700" rel="stylesheet'
            );

            $scripts = array(
                'assets/js/jquery.js',
                'assets/uikit/js/uikit.min.js',
                'assets/js/jquery-ui.min.js',
                'assets/js/cms_main.js',
                'assets/js/jquery-easing-1.3.js',
                'assets/js/jquery-transit-modified.js',
                'assets/js/layerslider.transitions.js',
                'assets/js/layerslider.kreaturamedia.jquery.js',
                'assets/uikit/js/addons/datepicker.min.js',
                'assets/uikit/js/addons/timepicker.min.js',
                'assets/uikit/js/addons/autocomplete.min.js',
                'assets/js/jquery.tabletojson.min.js'
            );

            $this->template->styles = array_merge( $this->template->styles, $styles );
            $this->template->scripts = array_merge( $this->template->scripts, $scripts );

        }
        parent::after();
    }
}