<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_Tutors extends Controller_CmsTemplate {

    protected $tutor_image_url = '';
    
    public function action_index()
    {
        $tutors_data = ORM::factory('Cms_Tutors')->find_all();
        
        $sort_order = array("id" => "asc");        
        $this->template->title .= " - CMS Tutors";
        $this->template->content = View::factory('cms/tutors_view');
        $this->template->content->tutors_data = $tutors_data;

    }
    
    public function action_sortToggle(){
        
    }
    
    public function action_addTutor(){
        $this->template->title .= " - CMS Add Tutor";
        $this->template->content = View::factory('cms/addTutor_view');
        $this->template->content->image = $this->tutor_image_url;
    }

    public function _add_new_tutor($filenm=''){

        $postin = $this->request->post();

        if(empty($postin['edit'])) { $tutor_user = ORM::factory('Cms_User'); } else {
        $tutor_user = ORM::factory('Cms_User')->where('ID_user','=',$postin['edit'])->find();
        }

        $tutor_user->ID_type_user = 2;
        $tutor_user->user_name = HTML::chars($postin['username']);
        if(!empty($postin['password'])) {
        $tutor_user->password = Auth::instance()->hash_password($postin['password']);  }
        $tutor_user->first_name = HTML::chars($postin['first_name']);
        $tutor_user->last_name = HTML::chars($postin['last_name']);
        $tutor_user->email = HTML::chars($postin['email']);
        $tutor_user->positions = HTML::chars($postin['position']);

        if($filenm!=''){
        $tutor_user->photoURL = HTML::chars($filenm);}

        if(empty($postin['edit'])) {
            $tutor_user->save();
            } else {
              $tutor_user->update();
              }

        if(empty($postin['edit'])) {
            $user_id = $tutor_user->pk();
        }

        if(empty($postin['edit'])) { $user_data = ORM::factory('Cms_UserTutors'); $user_data->ID_user = $user_id;} else {
        $user_data = ORM::factory('Cms_UserTutors')->where('ID_user','=',$postin['edit'])->find();
        }

        $user_data->location = HTML::chars($postin['location']);
        $user_data->university = HTML::chars($postin['university']);
        $user_data->subject = HTML::chars($postin['subject']);
        $user_data->about = HTML::chars($postin['about']);
        
        if(trim(HTML::chars($postin['spec-one']))!=''){ $postin['spec-one'] = '<li>'.HTML::chars($postin['spec-one']).'</li>'; }
        if(trim(HTML::chars($postin['spec-two']))!=''){ $postin['spec-two'] = '<li>'.HTML::chars($postin['spec-two']).'</li>'; }
        if(trim(HTML::chars($postin['spec-three']))!=''){ $postin['spec-three'] = '<li>'.HTML::chars($postin['spec-three']).'</li>'; }

        $specs = HTML::chars($postin['spec-one']).HTML::chars($postin['spec-two']).HTML::chars($postin['spec-three']);
        $user_data->specialities = $specs;
        $user_data->ID_user = $tutor_user->ID_user;
        if(empty($postin['edit'])) {
        $user_data->save();} else { $user_data->update();}

   }



   public function action_editTutor(){

       $tutor_data = ORM::factory('Cms_Tutors')->where('ID_user','=',$this->request->param('id'))->find();
        $this->template->title .= " - Edit Tutor";
        $this->template->content = View::factory('cms/editTutor_view');
        $this->template->content->tutor_data = $tutor_data;
        $spec = array();
        $spec = explode('</li><li>',trim(html_entity_decode($tutor_data->specialities), '<li></li>'));
        $spec[0] = array_key_exists("0",$spec) ? $spec[0] : NULL;
        $spec[1] = array_key_exists("1",$spec) ? $spec[1] : NULL;
        $spec[2] = array_key_exists("2",$spec) ? $spec[2] : NULL;
        $this->template->content->specs = $spec;


   }

   public function action_delete(){
//       $getin = $this->request->param('id');
//       DB::delete('user_tutor')->where('ID_user', '=', $getin)->execute();
//       DB::delete('users')->where('ID_user', '=', $getin)->execute();
//       HTTP::redirect("Cms/Tutors/index");
          }

    public function action_upload()
    {

        $error_message = NULL;
        $filename = NULL;
 
        if ($this->request->method() == Request::POST)
        {
            if (isset($_FILES['tutorPhoto']))
            {
                $filename = $this->_save_image($_FILES['tutorPhoto']);
            }
        }
 
        //if ( ! $filename)
        //{
        //    $error_message = 'There was a problem while uploading the image.
        //        Make sure it is uploaded and must be JPG/PNG/GIF file.';
        //}
        //if(!empty($_FILES['photoTutor']['name']))   {
        //$this->_add_new_tutor($filename); } else {$this->_add_new_tutor();}

        $this->_add_new_tutor($filename);

        HTTP::redirect("Cms/Tutors/index");
    }
 
    protected function _save_image($image)
    {
        if (
            ! Upload::valid($image) OR
            ! Upload::not_empty($image) OR
            ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif')))
        {
            return FALSE;
        }
 
        $directory = DOCROOT.'assets/images/tutors/';
 
        if ($file = Upload::save($image, NULL, $directory))
        {
            $filename = strtolower(Text::random('alnum', 20)).'.jpg';
 
            Image::factory($file)
                ->resize(200, 200, Image::WIDTH)
                ->save($directory.$filename);
 
            // Delete the temporary file
            unlink($file);
 
            return $filename;
        }
 
        return FALSE;
    }

}