<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Front_Messages extends Controller_Front_IvyPortalFrontTemplate {
    
    public function action_index() {
        if(!Auth::instance()->get_user())  $this->redirect('../');
        $this->action_Inbox();
    }
    
    public function action_Inbox(){
        if(!Auth::instance()->get_user())  $this->redirect('../');
        
        $mess = ORM::factory('Front_Message');
        $users = ORM::factory('AuthUser');
        $pagination = Pagination::factory(array(
         'total_items' => $mess->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)->and_where('type', '=', '0')->count_all(),
         'items_per_page' => 10,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $messages = $mess->offset($pagination->offset)
                ->limit($pagination->items_per_page)
                ->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)
                ->and_where('type', '=', '0')
                ->and_where('erased_by_receiver', '=', NULL)
                ->order_by('send_date', 'desc')
                ->find_all();
        
        $this->template->title = 'Messages - The Ivy Key Portal';
        $this->template->header->page = 'Messages';
        $this->template->content = View::factory('front/messages', array('users' => $users, 'pagination' => $pagination));
        $this->template->content->messages = $messages;
        $this->template->content->box = 'inbox';
        $this->template->content->numberInbox = $this->checkInboxContent();
        $this->template->content->numberHomework = $this->checkHomeworkContent();
        $this->template->content->currentTutors = $this->getCurrentTutors();
        $this->template->content->activeStudent = $this->template->activeStudent;
        
    }
    
    public function action_Sent(){
        if(!Auth::instance()->get_user())  $this->redirect('../');
        
        $mess = ORM::factory('Front_Message');
        $users = ORM::factory('AuthUser');
        $pagination = Pagination::factory(array(
         'total_items' => $mess->where('ID_sender','=',Auth::instance()->get_user()->ID_user)->count_all(),
         'items_per_page' => 10,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $messages = $mess->offset($pagination->offset)->limit($pagination->items_per_page)->where('ID_sender','=',Auth::instance()->get_user()->ID_user)->and_where('erased_by_sender', '=', NULL)->order_by('send_date', 'desc')->find_all();
        
        $this->template->title = 'Messages - The Ivy Key Portal';
        $this->template->header->page = 'Messages';
        $this->template->content = View::factory('front/messages', array('users' => $users, 'pagination' => $pagination));
        $this->template->content->messages = $messages;
        $this->template->content->box = 'outbox';
        $this->template->content->numberInbox = $this->checkInboxContent();
        $this->template->content->numberHomework = $this->checkHomeworkContent();
        $this->template->content->currentTutors = $this->getCurrentTutors();
        $this->template->content->activeStudent = $this->template->activeStudent;
    }
    
    public function action_Homework(){
        if(!Auth::instance()->get_user())  $this->redirect('../');
        
        $mess = ORM::factory('Front_Message');
        $users = ORM::factory('AuthUser');
        $pagination = Pagination::factory(array(
         'total_items' => $mess->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)->and_where('type', '=', '1')->count_all(),
         'items_per_page' => 10,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $messages = $mess->offset($pagination->offset)
                ->limit($pagination->items_per_page)
                ->where('ID_receiver','=',Auth::instance()->get_user()->ID_user)
                ->and_where('type', '=', '1')
                ->and_where('erased_by_receiver', '=', NULL)
                ->order_by('send_date', 'desc')
                ->find_all();
        
        $this->template->title = 'Messages - The Ivy Key Portal';
        $this->template->header->page = 'Messages';
        $this->template->content = View::factory('front/messages', array('users' => $users, 'pagination' => $pagination));
        $this->template->content->messages = $messages;
        $this->template->content->box = 'homework';
        $this->template->content->numberInbox = $this->checkInboxContent();
        $this->template->content->numberHomework = $this->checkHomeworkContent();
        $this->template->content->currentTutors = $this->getCurrentTutors();
        $this->template->content->activeStudent = $this->template->activeStudent;
    }
    
    public function action_newMessage(){

        $mess = ORM::factory('Front_Message');
        
        if(!Auth::instance()->get_user())  $this->redirect('../');
        
        $post = Validation::factory( $_POST );
        $file = Validation::factory( $_FILES );

        if ( Request::current()->method() == Request::POST && $post->check() && $file->check() ) {
                


                if(!empty($file['name'])){
                $filename = Upload::save( $file['filename'], NULL, DOCROOT . 'assets/attachments' );}

                if ( $filename === false ) {
                        throw new Exception( 'Unable to save uploaded file!' );
                } else {

                    $filename = end(explode('/',$filename));

                    $saveMessage = $mess->saveMessage($post, $filename);
                
                }
                Http::redirect('Front/Messages/Sent');
        }
        
    }
    
    protected function checkInboxContent(){
        $counter = ORM::factory('Front_Message')
                ->where('ID_receiver', '=', Auth::instance()->get_user()->ID_user)
                ->and_where('type', '=', '0')
                ->and_where('seen', '=', '0')
                ->count_all();
        if($counter > 0) {
            return ' ('.$counter.')';
        } else { return '';}
    }

    protected function checkHomeworkContent(){
        $counter = ORM::factory('Front_Message')
                ->where('ID_receiver', '=', Auth::instance()->get_user()->ID_user)
                ->and_where('type', '=', '1')
                ->and_where('seen', '=', '0')
                ->count_all();
        if($counter > 0) {
            return ' ('.$counter.')';
        } else { return '';}
    }

    protected function getCurrentTutors(){

        $userID = Auth::instance()->get_user()->ID_user;

        $currTut = Model::factory('Front_Groups')->getCurrentTutors($userID);
        
        return $currTut;

    }
    
}

