<?php

require_once 'DBpdo/DBpdo.php';

class Model_users {

    function list_all_users() {
        $db = connect();
        $query = $db->prepare('SELECT * FROM user');
        return executePDO($query, 1);
    }
    
    function list_all_specific_users($type) {
        $db = connect();
        $query = $db->prepare('SELECT * FROM user WHERE ID_type_user = "'.$type.'"');
        return executePDO($query, 1);
    }
    
    function list_all_active_users($type) {
        $db = connect();
        $query = $db->prepare('SELECT * FROM user WHERE ID_type_user = "'.$type.'" AND active = "1"');
        return executePDO($query, 1);
    }

    function list_journal($ID_group_schedule) {
        $db = connect();
        $query = $db->prepare('CALL z_sel_groups_students_module_journal(?)');
        $query->bindParam(1, $ID_group_schedule);
        return executePDO($query, 1);
    }

    function update_student_attendance() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $ID_groups_schedule = $current->post('ID_groups_schedule');
        $yes_no = ($current->post('checked') == 'true') ? 1 : 0;
        $date_time = date("Y-m-d h:i:s");
        $db = connect();
        $query = $db->prepare('CALL z_upd_student_module_attendance(?,?,?,?)');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $ID_groups_schedule);
        $query->bindParam(3, $yes_no);
        $query->bindParam(4, $date_time);
        executePDO($query, 0);
        print_r($date_time);
    }

    function update_student_homework() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $ID_groups_schedule = $current->post('ID_groups_schedule');
        $ID_type_marks = $current->post('selected');
        $db = connect();
        $query = $db->prepare('CALL z_upd_student_module_homework(?,?,?)');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $ID_groups_schedule);
        $query->bindParam(3, $ID_type_marks);
        executePDO($query, 0);
        print_r('Updated');
    }

    function update_student_testscore() {
        $current = Request::current();
        $ID_user = $current->post('ID_user');
        $ID_groups_schedule = $current->post('ID_groups_schedule');
        $test_score = $current->post('test_score');
        $db = connect();
        $query = $db->prepare('CALL z_upd_student_module_test(?,?,?)');
        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $ID_groups_schedule);
        $query->bindParam(3, $test_score);
        executePDO($query, 0);
        print_r('Updated');
    }

    /////////////////////////////////////////////////////////////////////////////////

    function student_course_review($p_ID_user_student, $p_ID_groups) {
        $db = connect();
//        $query = $db->prepare('CALL z_sel_groups_students_course_journal(?, ?)');
//        $query->bindParam(1, $p_ID_user_student);
//        $query->bindParam(2, $p_ID_course); 

        $query = $db->prepare('select groups_students.test_one,
			 groups_students.test_two,
			 groups_students.test_three,
			 groups_students.test_one_pdf,
			 groups_students.test_two_pdf,
			 groups_students.test_three_pdf
                         from   groups_students
                         where  groups_students.ID_user=? and groups_students.ID_groups=? ;');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_groups);
        $data[0] = executePDO($query, 1);

        $query = $db->prepare('select groups.ID_course,
			 course.name as course_name,
			 groups.name as group_name,
			 groups_schedule.ID_course_module,
 			 course_module.name as module_name,
 			 groups_schedule.ID_groups_schedule,
			 groups_schedule.date_time,
			 user.ID_user,
		 	 user.first_name,
			 user.last_name,
			 user.photoURL,
			 groups_students_module.attendance,
			 groups_students_module.attendance_timestamp,
			 groups_students_module.ID_type_marks
                         from   groups_students_module	inner join user on user.ID_user=groups_students_module.ID_user
											inner join user_student on user_student.ID_user=user.ID_user	 
											inner join groups_schedule on groups_schedule.ID_groups_schedule=groups_students_module.ID_groups_schedule
											inner join course_module on course_module.ID_course_module=groups_schedule.ID_course_module
											inner join course on course.ID_course=course_module.ID_course
											inner join groups on groups_schedule.ID_groups=groups.ID_groups
                         where  groups_students_module.ID_user=? and groups.ID_groups=?;');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_groups);
        $data[1] = executePDO($query, 1);

        return $data;
    }

    function spreadsheet_student($p_ID_user_student, $p_ID_course) {
        $db = connect();
        $query = $db->prepare('CALL z_sel_student_spreadsheet_by_course(?, ?)');
        $query->bindParam(1, $p_ID_user_student);
        $query->bindParam(2, $p_ID_course);
        return executePDO($query, 4);
    }

    function spreadsheet_admin($p_ID_groups) {
        $db = connect();
//        $query = $db->prepare('CALL z_sel_admin_spreadsheet_by_course(?)');
//        $query->bindParam(1, $p_ID_course);
//        return executePDO($query, 4);

        $query = $db->prepare('select groups.ID_groups,
                                      location.name as location_name,
                                      course.name as course_name,
                                      groups.name as group_name
                               from   groups inner join course on course.ID_course=groups.ID_course
                                             inner join location on location.ID_location=groups.ID_location
                               where  groups.ID_groups=?;');
        $query->bindParam(1, $p_ID_groups);
        $data[0] = executePDO($query, 1);

        $query = $db->prepare('select count(groups_schedule.ID_groups_schedule) as count_classes
                               from   groups_schedule
                               where  groups_schedule.ID_groups=?;');
        $query->bindParam(1, $p_ID_groups);
        $data[1] = executePDO($query, 1);

        $query = $db->prepare('select groups_schedule.ID_groups AS ID_groups, 
                                      groups_students_module.ID_user AS ID_user, 
                                      sum(groups_students_module.attendance) AS attendance, 
                                      sum(type_marks.points) AS marks
                               from   groups_schedule inner join groups_students_module ON groups_students_module.ID_groups_schedule = groups_schedule.ID_groups_schedule
				   		      inner join type_marks ON groups_students_module.ID_type_marks = type_marks.ID_type_mark
                               where groups_schedule.ID_groups = ?
                               group by groups_students_module.ID_user
                               order by groups_students_module.ID_user;');
        $query->bindParam(1, $p_ID_groups);
        $data[2] = executePDO($query, 1);

        $query = $db->prepare('select groups_students.ID_groups AS ID_groups,
                                      user.first_name,
                                      user.last_name,
                                      user.photoURL, 
                                      groups_students.test_one AS test_one, 
                                      groups_students.test_two AS test_two, 
                                      groups_students.test_three AS test_three,
                                      groups_students.test_one_pdf,
                                      groups_students.test_two_pdf,
                                      groups_students.test_three_pdf
                               from   groups_students inner join user on user.ID_user=groups_students.ID_user
                               where  groups_students.ID_groups = ?;');
        $query->bindParam(1, $p_ID_groups);
        $data[3] = executePDO($query, 1);
        return $data;
    }

    function find_school() {
        $current = Request::current();
        $par = $current->post('search');
        $par = trim($par);
        $name_or_zip = 'zip';
        if (strlen($par) == 5) {
            for ($i = 0; $i < 5; $i++) {
                if (!is_numeric($par[$i])) {
                    $name_or_zip = 'name';
                    break;
                }
            }
        } else {
            $name_or_zip = 'name';
        }
        $sql = '';
        if ($name_or_zip == 'zip') {
            $sql = 'select location.ID_location,
                           type_location.name as type,
                           location.name, 
                           location.address,
                           location.county,
                           location.zip_code
                    from   location inner join type_location on type_location.ID_type_location=location.ID_type_location
                    where  location.ID_location>20 and location.zip_code like ("' . $par . '");';
        } else {
            $del = ' ';
            $arr = explode($del, $par);
            $bool = true;
            $sql = 'select location.ID_location,
                           type_location.name as type,
                           location.name, 
                           location.address,
                           location.county,
                           location.zip_code
                    from   location inner join type_location on type_location.ID_type_location=location.ID_type_location
                    where  location.ID_location>20 and (';
            foreach ($arr as $value) {
                if ($bool) {
                    $sql = $sql . ' location.name like ("%' . $value . '%")';
                    $bool = false;
                } else {
                    $sql = $sql . ' or location.name like ("%' . $value . '%")';
                }
            }
            $sql = $sql . ');';
        }
        $db = connect();
        $query = $db->prepare($sql);
        return executePDO($query, 1);
    }
    
    function find_program(){
        $current = Request::current();
        $subject_search = strtolower($current->post('search'));
        
        $subject_search = str_replace(',', ' ', $subject_search);
        $subject_search = preg_replace("/[[:blank:]]+/"," ",$subject_search);
        $subject_search = explode(" ",$subject_search);
        
               
        $result = array();
                
        //foreach ($subject_search as $search) {
            
        $db = connect();
        $query = 'select ID_programs, name, start_date, for_exam, first_name, last_name, school_name, school_address, school_county, school_zip '
                . 'from view_programs '
                . 'where name like ';
        
        
        foreach ($subject_search as $search) {
            $query .= '("%'.$search.'%") or name like ';
        }
        $query = rtrim($query,'or name like ');
        $query .= ' or school_name like ';
        
        foreach ($subject_search as $search) {
            $query .= '("%'.$search.'%") or school_name like ';
        }
        
        $query = rtrim($query,'or school_name like ');
        $query .= ' or school_zip like ';
        
        foreach ($subject_search as $search) {
            $query .= '("%'.$search.'%") or school_zip like ';
        }
        $query = rtrim($query,'or school_zip like ');
        $query .= ' group by ID_programs;';
        
        $query = $db->prepare($query);
        $arr = executePDO($query, 1);
        return $arr;
    }
    
    function find_tutor() {
        
        $current = Request::current();
        $subject_search = strtolower($current->post('subject'));
        $location_search = $subject_search;

        $db = connect();
        $query = $db->prepare('select ID_user, location, subject from user_tutor;');
        $arr = executePDO($query, 1);

        $sql = 'select user.ID_user,
                       user.first_name,
                       user.last_name,
                       user.photoURL,
                       user_tutor.university,
                       user_tutor.location,
                       user_tutor.subject
                from   user inner join user_tutor on user_tutor.ID_user=user.ID_user
                where  user.ID_user in (';
        $where = '';
        $dont_add_coma = true;

        foreach ($arr as $value) {
            $subject = strtolower($value['subject']);
            if (strlen($subject_search) > 0) {
                if (strpos($subject, $subject_search) !== false) {
                    if ($dont_add_coma) {
                        $where = $where . $value['ID_user'];
                        $dont_add_coma = false;
                    } else {
                        $where = $where . ',' . $value['ID_user'];
                    }
                }
            }
            $subject = strtolower($value['location']);
            if (strlen($location_search) > 0) {
                if (strpos($subject, $location_search) !== false) {
                    if ($dont_add_coma) {
                        $where = $where . $value['ID_user'];
                        $dont_add_coma = false;
                    } else {
                        $where = $where . ',' . $value['ID_user'];
                    }
                }
            }
        }
        $sql = $sql . $where . ');';
        if (strlen($where) > 0) {
            $query = $db->prepare($sql);
            $arr = executePDO($query, 1);
            $data = $arr;
            return $data;
        } else {
            $data[0]['first_name'] = 'not found';
            return $data;
        }
    }

    /////////////    cms    /////////////////////////
    /////////tutor////////
    function insert_tutor() {

        $current = Request::current();


        $user_name = $current->post('user_name');
        $first_name = $current->post('first_name');
        $last_name = $current->post('last_name');
        $photoURL = $current->post('photoURL');

        $location = $current->post('location');
        $university = $current->post('university');
        $subject = $current->post('subject');
        $about = $current->post('about');

        $db = connect();
        $query = $db->prepare('call z_cms_ins_tutor (?, ?, ?, ?, ?, ?, ?, ?);');

        $query->bindParam(1, $user_name);
        $query->bindParam(2, $first_name);
        $query->bindParam(3, $last_name);
        $query->bindParam(4, $photoURL);

        $query->bindParam(5, $location);
        $query->bindParam(6, $university);
        $query->bindParam(7, $subject);
        $query->bindParam(8, $about);

        return executePDO($query, 1);
    }

    function tutor_combo() {
        $db = connect();
        $query = $db->prepare('call z_cms_combo_tutor_all ();');
        $query->bindParam(1, $ID_user);
        return executePDO($query, 1);
    }

    function select_tutor($ID_user) {
        $db = connect();
        $query = $db->prepare('call z_cms_sel_tutor (?);');
        $query->bindParam(1, $ID_user);
        return executePDO($query, 1);
    }

    function update_tutor() {
        $current = Request::current();

        $ID_user = $current->post('ID_user');
        $user_name = $current->post('user_name');
        $first_name = $current->post('first_name');
        $last_name = $current->post('last_name');
        $photoURL = $current->post('photoURL');

        $location = $current->post('location');
        $university = $current->post('university');
        $subject = $current->post('subject');
        $about = $current->post('about');

        $db = connect();
        $query = $db->prepare('call z_cms_upd_tutor (?, ?, ?, ?, ?, ?, ?, ?, ?);');

        $query->bindParam(1, $ID_user);
        $query->bindParam(2, $user_name);
        $query->bindParam(3, $first_name);
        $query->bindParam(4, $last_name);
        $query->bindParam(5, $photoURL);
        $query->bindParam(6, $location);
        $query->bindParam(7, $university);
        $query->bindParam(8, $subject);
        $query->bindParam(9, $about);

        return executePDO($query, 1);
    }

    /////////tutor////////
}
