<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_Testimonials extends Controller_CmsTemplate {

    protected $testimonial_image_url = '';
    
    public function action_index()
    {
        $testimonials_data = ORM::factory('testimonials')->find_all();

        $sort_order = array("id" => "asc");
        $this->template->title .= " - CMS Testimonials";
        $this->template->content = View::factory('cms/testimonials_view');
        $this->template->content->testimonials_data = $testimonials_data;

    }

    public function action_sortToggle(){

    }
    
    public function action_addTestimonial(){
        $this->template->title .= " - CMS Add Testimonial";
        $this->template->content = View::factory('cms/addTestimonial_view');
        $this->template->content->image = $this->testimonial_image_url;
    }

    public function _add_new_testimonial($filenm=''){

        $postin = $this->request->post();
        if(empty($postin['edit'])) { $visitor = ORM::factory('Cms_Visitor'); } else {
        $testim = ORM::factory('Cms_UserTestimonials')->where('ID_user_testimonial','=',$postin['edit'])->find();
        $visitor = ORM::factory('Cms_Visitor')->where('ID','=',$testim->ID_user)->find();
        }
        

        $visitor->first_name = HTML::chars($postin['first_name']);
        $visitor->last_name = HTML::chars($postin['last_name']);
        if($filenm!=''){
        $visitor->photoURL = HTML::chars($filenm);}

        if(empty($postin['edit'])) {
            $visitor->save();
            } else {
              $visitor->update();
              }

        if(empty($postin['edit'])) {
            $user_id = $visitor->pk();
        }

        if(empty($postin['edit'])) { $user_data = ORM::factory('Cms_UserTestimonials'); $user_data->ID_user = $user_id;} else {
        $user_data = ORM::factory('Cms_UserTestimonials')->where('ID_user_testimonial','=',$postin['edit'])->find();
        }

        $user_data->testimonial = HTML::chars($postin['testimonial']);
        $user_data->active = 1;

        $user_data->ID_user = $visitor->ID;
        if(empty($postin['edit'])) {
        $user_data->save();} else { $user_data->update();}

   }



   public function action_editTestimonial(){

        $testimonial = ORM::factory('Cms_UserTestimonials')->where('ID_user_testimonial','=',$this->request->param('id'))->find();
        $visitor = ORM::factory('Cms_Visitor')->where('ID','=',$testimonial->ID_user)->find();
        $this->template->title .= " - Edit Testimonial";
        $this->template->content = View::factory('cms/editTestimonial_view');
        $this->template->content->testimonial = $testimonial;
        $this->template->content->visitor = $visitor;
   }

   public function action_delete(){
//       $getin = $this->request->param('id');
//       DB::delete('user_tutor')->where('ID_user', '=', $getin)->execute();
//       DB::delete('users')->where('ID_user', '=', $getin)->execute();
//       HTTP::redirect("Cms/Tutors/index");
          }

    public function action_upload()
    {

        $error_message = NULL;
        $filename = NULL;
 
        if ($this->request->method() == Request::POST)
        {
            if (isset($_FILES['tutorPhoto']))
            {
                $filename = $this->_save_image($_FILES['tutorPhoto']);
            }
        }
 
        //if ( ! $filename)
        //{
        //    $error_message = 'There was a problem while uploading the image.
        //        Make sure it is uploaded and must be JPG/PNG/GIF file.';
        //}
        //if(!empty($_FILES['photoTutor']['name']))   {
        //$this->_add_new_tutor($filename); } else {$this->_add_new_tutor();}

        $this->_add_new_testimonial($filename);

        HTTP::redirect("Cms/Testimonials/index");
    }
 
    protected function _save_image($image)
    {
        if (
            ! Upload::valid($image) OR
            ! Upload::not_empty($image) OR
            ! Upload::type($image, array('jpg', 'jpeg', 'png', 'gif')))
        {
            return FALSE;
        }
 
        $directory = DOCROOT.'assets/images/testimonials/';
 
        if ($file = Upload::save($image, NULL, $directory))
        {
            $exten = explode(".", $image['name']);
            $ext = end($exten);
            $filename = strtolower(Text::random('alnum', 20)).'.'.$ext;
 
            Image::factory($file)
                ->resize(200, 200, Image::WIDTH)
                ->save($directory.$filename);
 
            // Delete the temporary file
            unlink($file);
 
            return $filename;
        }
 
        return FALSE;
    }

}