<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_Schools extends Controller_CmsTemplate {
    
    public function action_index(){
        $this->redirect('Cms/Schools/pagek5/?page=1');
    }
    
    public function action_index68(){
        $this->redirect('Cms/Schools/page68/?page=1');
    }
    
    public function action_indexHS(){
        $this->redirect('Cms/Schools/pageHS/?page=1');
    }
       
    public function action_pagek5()
    {
        $schools_data = ORM::factory('Cms_School_Schools');
        $pagination = Pagination::factory(array(
         'total_items' => $schools_data->where('ID_type','=','1')->count_all(),
         'items_per_page' => 20,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $data = $schools_data->offset($pagination->offset)->limit($pagination->items_per_page)->where('ID_type','=','1')->find_all();
        
        $sort_order = array("name" => "asc");
        $this->template->title .= " - CMS K-5 Schools";
        $this->template->content = View::factory('cms/K5schools_view', array('data' => $data, 'pagination' => $pagination));
        $this->template->content->schools_data = $data;
    }
    
    public function action_page68()
    {
        $schools_data = ORM::factory('Cms_School_Schools')->where('ID_type','=','2');
        $pagination = Pagination::factory(array(
         'total_items' => $schools_data->where('ID_type','=','2')->count_all(),
         'items_per_page' => 20,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $data = $schools_data->offset($pagination->offset)->limit($pagination->items_per_page)->where('ID_type','=','2')->find_all();
        
        $sort_order = array("name" => "asc");
        $this->template->title .= " - CMS 6-8 Schools";
        $this->template->content = View::factory('cms/K5schools_view', array('data' => $data, 'pagination' => $pagination));
        $this->template->content->schools_data = $data;
    }
    public function action_pageHS()
    {
        $schools_data = ORM::factory('Cms_School_Schools')->where('ID_type','=','3');
        $pagination = Pagination::factory(array(
         'total_items' => $schools_data->where('ID_type','=','3')->count_all(),
         'items_per_page' => 20,
         )
        );
        $pagination->route_params(array('controller' => $this->request->controller(), 'action' => $this->request->action()));
        $data = $schools_data->offset($pagination->offset)->limit($pagination->items_per_page)->where('ID_type','=','3')->find_all();
        
        $sort_order = array("name" => "asc");
        $this->template->title .= " - CMS High Schools";
        $this->template->content = View::factory('cms/K5schools_view', array('data' => $data, 'pagination' => $pagination));
        $this->template->content->schools_data = $data;
    }

    public function action_sortToggle(){

    }
    public function action_editSchool(){
        
        $school = ORM::factory('Cms_School_Schools')->where('ID_location','=',$this->request->param('id'))->find();
        $school_type = ORM::factory('Cms_School_SchoolType')->find_all();
        $this->template->title .= " - Edit School";
        $this->template->content = View::factory('cms/editSchool_view');
        $this->template->content->school = $school;
        $this->template->content->school_type = $school_type;
        
   }
   public function action_addSchool(){
        
        $school_type = ORM::factory('Cms_School_SchoolType')->find_all();
        $this->template->title .= " - Add School";
        $this->template->content = View::factory('cms/addSchool_view');
        $this->template->content->school_type = $school_type;
       
   }

   public function action_delete(){
       $getin = $this->request->param('id');
       DB::delete('location')->where('ID_location', '=', $getin)->execute();
       $this->action_index();
          }

   public function action_edit(){
        $school_edit = ORM::factory('Cms_School_Location')->where('ID_location','=',  $this->request->post('ID_location'))->find();
        $school_edit->ID_type_location = $this->request->post('school_type');
        $school_edit->name = $this->request->post('school_name');
        $school_edit->address = $this->request->post('school_address');
        $school_edit->zip_code = $this->request->post('zip_code');
        $school_edit->county = $this->request->post('county');
        $school_edit->update();
        $this->action_index();
   }
   public function action_add(){
        $school_edit = ORM::factory('Cms_School_Location');
        $school_edit->ID_type_location = $this->request->post('school_type');
        $school_edit->name = $this->request->post('school_name');
        $school_edit->address = $this->request->post('school_address');
        $school_edit->zip_code = $this->request->post('zip_code');
        $school_edit->county = $this->request->post('county');
        $school_edit->save();
        $this->action_index();
   }
}