<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Cms_Programs extends Controller_CmsTemplate {
    
    protected $model;
    protected $title;
    
    public function action_index(){
        
        if ($this->request->param('id')=='') {
            $default_course = 4;
        } else {
                $default_course = $this->request->param ('id');
        }
        //echo $default_course; die();
        $this->template->title .= " - Programs";
        $this->template->content = View::factory('cms/programs/programs_view');
        
        $programModel = ORM::factory('Cms_Programs_Programs')->list_all_programs('ID', 'DESC', $default_course);
        $courseModel = ORM::factory('Cms_Programs_Course');
        $courses = $courseModel->where('active','=','1')->find_all();
        
        $this->template->content
                ->bind('courses', $courses)
                ->bind('program', $programModel)
                ->set('default_course', $default_course);
    }
    
    public function action_editProgram() {
        $courseModel = ORM::factory('Cms_Programs_Course');
        $schools = ORM::factory('Cms_School_Location')->order_by('name')->find_all();
        $tutors = ORM::factory('Cms_Tutors')->order_by('first_name')->find_all();
        $program_type = ORM::factory('Cms_Programs_Programtype')->order_by('ID_program_type')->find_all();
        $courses = $courseModel->where('active','=','1')->find_all();
        $program = ORM::factory('Cms_Programs_Program')->where('ID_programs','=',$this->request->param('id'))->find();
        $this->template->title .= " - Edit Program";
        $this->template->content = View::factory('cms/programs/editProgram_view');
        $this->template->content
                ->set('program', $program)
                ->set('program_id',$this->request->param('id'))
                ->set('schools', $schools)
                ->set('tutors', $tutors)
                ->set('program_type', $program_type)
                ->set('courses', $courses);
    }
    

    public function action_editSchedule() {
        $program_id = $this->request->param('id');
        $program = ORM::factory('Cms_Programs_Program')->where('ID_programs','=',$this->request->param('id'))->find();
        $courseModel = ORM::factory('Cms_Programs_Course');
        $schedules = ORM::factory('Cms_Programs_Schedule')->where('ID_programs', '=', $program_id)->find_all();
        $this->template->title .= " - Edit Schedule";
        $this->template->content = View::factory('cms/programs/editSchedule_view');
        $this->template->content->schedules = $schedules;
        $this->template->content->program_id = $program_id;
        $this->template->content->program = $program;
        $this->template->content->courses = $courseModel->where('active','=','1')->find_all();
    }
    
    public function action_addProgram() {
        $courseModel = ORM::factory('Cms_Programs_Course');
        $schools = ORM::factory('Cms_School_Location')->order_by('name')->find_all();
        $tutors = ORM::factory('Cms_Tutors')->order_by('first_name')->find_all();
        $program_type = ORM::factory('Cms_Programs_Programtype')->order_by('ID_program_type')->find_all();
        $courses = $courseModel->where('active','=','1')->find_all();
        $this->template->title .= " - Add Program";
        $this->template->content = View::factory('cms/programs/addProgram_view');
        $this->template->content
                ->set('schools', $schools)
                ->set('tutors', $tutors)
                ->set('program_type', $program_type)
                ->set('courses', $courses);
    }
    
    public function action_delete(){
       $getin = $this->request->param('id');
       DB::delete('programs')->where('ID_programs', '=', $getin)->execute();
       HTTP::redirect( 'Cms/Programs/index/4' , 302 );
       }
          
    public function action_edit() {
        
        $program_edit = ORM::factory('Cms_Programs_Program')->where('ID_programs','=',$this->request->post('ID_programs'))->find();
        $program_edit->ID_course = $this->request->post('course_type');
        $program_edit->ID_program_type = $this->request->post('program_type');
        $program_edit->ID_location = $this->request->post('school');
        $program_edit->ID_user = $this->request->post('tutor');
        $program_edit->start_date = date_format(new DateTime($this->request->post('start_date')), "Y-m-d");
        $program_edit->for_exam = $this->request->post('for_exam');
        $program_edit->meets_on = $this->request->post('meets_on');
        $program_edit->price = $this->request->post('price');
        $program_edit->update();
        HTTP::redirect( 'Cms/Programs/index/'.$this->request->post('course_type') , 302 );
    }
    
    public function action_add() {
        
        $program_edit = ORM::factory('Cms_Programs_Program');
        $program_edit->ID_course = $this->request->post('course_type');
        $program_edit->ID_program_type = $this->request->post('program_type');
        $program_edit->ID_location = $this->request->post('school');
        $program_edit->ID_user = $this->request->post('tutor');
        $program_edit->start_date = date_format(new DateTime($this->request->post('start_date')), "Y-m-d");
        $program_edit->for_exam = $this->request->post('for_exam');
        $program_edit->meets_on = $this->request->post('meets_on');
        $program_edit->price = $this->request->post('price');
        $program_edit->save();
        HTTP::redirect( 'Cms/Programs/index/'.$this->request->post('course_type') , 302 );
    }
}
