<?php

require_once 'phing/BuildFileTest.php';

/**
 * Tests the Condition Task
 *
 * @author  Michiel Rook <mrook@php.net>
 * @version $Id: c3dc7c66a8b1cdfe1d97f50f525c1186b6daaaaf $
 * @package phing.tasks.system
 */
class ConditionTaskTest extends BuildFileTest
{

    public function setUp()
    {
        $this->configureProject(
            PHING_TEST_BASE . '/etc/tasks/system/ConditionTest.xml'
        );
    }

    public function testEquals()
    {
        $this->executeTarget(__FUNCTION__);
        $this->assertPropertySet('isEquals');
    }

    public function testContains()
    {
        $this->executeTarget(__FUNCTION__);
        $this->assertPropertySet('isContains');
    }

    public function testCustomCondition()
    {
        $this->executeTarget(__FUNCTION__);
        $this->assertPropertySet('isCustom');
    }

    public function testReferenceExists()
    {
        $this->executeTarget(__FUNCTION__);
        $this->assertPropertyUnset('ref.exists');
    }

    public function testSocketCondition()
    {
        $this->executeTarget(__FUNCTION__);
        $this->assertPropertyUnset('socket  ');
    }
}
