<?php

/*
 *  $Id: b751f1c8f0dcd03b0a5e60b5a38f27b9ab29385d $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://phing.info>.
 */

require_once 'phing/BuildFileTest.php';

/**
 * Tests for PhpDependTask
 *
 * @author Michiel Rook <mrook@php.net>
 * @package phing.tasks.ext.pdepend
 */
class PhpDependTaskTest extends BuildFileTest
{

    public function setUp()
    {
        $this->configureProject(PHING_TEST_BASE . "/etc/tasks/ext/pdepend/build.xml");
    }

    public function testLoggerSummary()
    {
        ob_start();
        $this->executeTarget(__FUNCTION__);
        ob_end_clean();
        $filename = PHING_TEST_BASE . '/etc/tasks/ext/pdepend/tempoutput';
        $this->assertFileExists($filename);
        unlink($filename);
    }

    public function testAnalyzer()
    {
        ob_start();
        $this->executeTarget(__FUNCTION__);
        ob_end_clean();
        $filename = PHING_TEST_BASE . '/etc/tasks/ext/pdepend/tempoutput';
        $this->assertFileExists($filename);
        unlink($filename);
    }
}
