<?php
/*
 *  $Id: 0dfb6d3dcfcc2d33ca51b5b1107a2a7fa053be4c $
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * This software consists of voluntary contributions made by many individuals
 * and is licensed under the LGPL. For more information please see
 * <http://phing.info>.
 */

require_once 'HTTP/Request2/Adapter/Mock.php';

/**
 * A subclass of Mock adapter for HTTP_Request2 that also saves array representations of sent requests
 *
 * @author Alexey Borzov <avb@php.net>
 * @package phing.tasks.ext
 */
class TraceHttpAdapter extends HTTP_Request2_Adapter_Mock
{
    public $requests;

    public function sendRequest(HTTP_Request2 $request)
    {
        $this->requests[] = array(
            'config' => $request->getConfig(),
            'url' => $request->getUrl(),
            'method' => $request->getMethod(),
            'headers' => $request->getHeaders(),
            'auth' => $request->getAuth(),
            'body' => (string) $request->getBody()
        );

        return parent::sendRequest($request);
    }
}
