@extends('master')

@section('content')

<div class="new_row">
    <div class="column-15 top_space_tutors">
        <div class="large_top_icon_tutors">
        	<img src="{{ URL::asset('images/tutor-icon.png') }}" alt="">
        	<div class="large_top_text">Our Tutors</div>
                                
    	</div>
</div>
<div class="new_row row-fixed">
    <div class="column-20">
        <img src="{{ URL::asset('images/tutorTop.jpg') }}" alt="">
    </div>
</div>

<div class="new_row title1">
    <div class="column-20">
        <p>Where tutoring meets mentoring</p>
    </div>
</div>
<div class="push_underlayer1">

    <div class="new_row">
        <div id="mid_text" class="column-12 col-border-top push-left-4">
            <p>The Ivy Key’s tutors are all graduates of Ivy League schools or institutions of equal caliber. Our results-oriented tutors guarantee score increases for students of all academic levels and backgrounds.
Tutors are assigned based on subject mastery, personality fit and teaching style, and each tutor tailors instruction to a student’s individual academic needs. Our tutors have the expertise to not only improve student scores and academic skills, but also serve as role models and mentors to lead students to their personal potential. At the Ivy Key we believe a great mind never goes out of style, and we hope to inspire this ethos in every one of our students.
</p>
        </div>
    </div>
    <div class="new_row">
        <div class="column-20 tutors-video-box">
        <div class="new_row">
            <div class="column-5 push-left-4 col-transparent">
                <p class="tutor-find-box">Let's find a tutor for you. The Ivy Key's highly qualified tutors are located all over New York City. We can match you with a tutor that conveniently suits you best based on subject and location. All of our services and programs are instructed by our team of Ivy League tutors.</p>
            </div>
            <div class="column-1 push-left-4 empty"></div>
            <div class="column-5 push-left-4 col-transparent">
                <div class="tutors-search-box">
                    <p>Browse tutors by subject</p>
                    <form name="tutors-search-form" action="search/tutors_by_subject" method="post">
	                    <input type="text" name="subject" value="">
	                    <input type="submit" name="submit" value="Search">
                	</form>
                </div>
            </div>
        </div>   
        </div>
    </div>
    <div class="new_row tutors-list">

		<div class="column-10 push-left-5">
			<div class="new_row">
				<?php $i=0; ?>
				@foreach($tutors as $tut)
					@if(!($i%4))
						</div><div class="new_row">
					@endif

					<div class="column-5 tutor-box">
						@if( $tut->photoURL == '' )
							<img src="{{ URL::asset('images/no-profile-image.png') }}" alt="">
						@else
							<img src="<?php echo 'images/users/' . $tut->photoURL; ?>" alt="">
						@endif
						<div class="mask-over">
							<a href="<?php echo 'tutor/profile/' . $tut->id; ?>">
                                <div class="tutor_image_overlay">
                                    <p class="spec-title">Specialities</p>
                                    <div class="tutor_overlay_text">
                                        <ul class="list_tut">
                                            <?php echo html_entity_decode($tut->specialities); ?>
                                        </ul>
                                    </div>
                                    <div class="button-tutor">View Profile</div>
                                </div>
                            </a>
						</div>
						<p class="name"><?= strtoupper($tut->name); ?></p>
					</div>
					<?php $i+=1; ?>
				@endforeach
			</div>	
			
		</div>
    </div>
</div>

<script>
	document.title = 'The Ivy Key - Tutors';
	
    $('.row-fixed-content').addClass('tutors-top-content');

    function playPause() {
        var videoClip = document.getElementById("videoClip");
        videoClip.setAttribute("controls", "controls");
        videoClip.play();
        document.getElementById("video-control").style.display = "none";
    }

</script>
@stop