@extends('master')

@section('content')
<div class="new_row">
        <div class="column-15 top_space_tutors">
            <div class="large_top_icon_tutors"><img src="{{ URL::asset('images/tutor-icon.png') }}" alt="">
                <div class="large_top_text">Our Services</div>
            </div>
        </div>
    </div>
    <div class="new_row row-fixed">
        <div class="column-20">
            <img src="{{ URL::asset('images/Services.jpg') }}" alt="">
        </div>
    </div>
    <div class="new_row title1">
        <div class="column-20">
            <p>Our Strategy for Your Success</p>
        </div>
    </div>
    <div class="push_underlayer1">
        <div class="new_row">
            <div id="mid_text" class="column-12 col-border-top push-left-4">
                <p>The Ivy Key is a New York City-based tutoring company which offers effective tutoring, mentoring,
                    and admissions consulting. The Ivy Key only employs tutors who have either graduated
                    from or are currently attending an Ivy League school or an institution of equal quality. The Ivy
                    Key places a special emphasis on recruiting graduates from Harvard University. Our instructors
                    model tenacity and academic achievement, inspiring our students to work with vigor both
                    inside and out of the academic arena. Our goal is to exemplify the skills needed to unlock the
                    door to a successful high school, college and professional career.</p>
            </div>
        </div>

        

        <div class="new_row title1">
            <div class="column-20">
                <p>I'm looking for...</p>
            </div>
        </div>
        <div class="new_row resizable services-resizable">
            <div class="column-one-third over-hidden click1">
            <a href="{{ URL::to('services/k5') }}">
                <div class="tileService">
                    <figure class="effect-ming">
                        <img src="http://www.theivykey.com/assets/images/isee.jpg" alt="img19"/>
                        <figcaption>
                            <h2><span>Grades K-5</span></h2>
                            <p>
                                Tutoring services for students from kindergarten to 5th grade. Services range from help in schoolwork to preparation for standardized testing.
                            </p>
                        </figcaption>           
                    </figure>
                </div>
                </a>
            </div>
            <div class="column-one-third over-hidden click2">
            <a href="{{ URL::to('services/grades6-8') }}">
                <div class="tileService">
                    <figure class="effect-ming">
                        <img src="http://www.theivykey.com/assets/images/6-8.jpg" alt="img13"/>
                        <figcaption>
                            <h2><span>Grade 6-8</span></h2>
                            <p>Tutoring services for students from 6th to 8th grade. Services range from help in schoolwork to preparation for standardized testing.</p>
                        </figcaption>           
                    </figure>
                </div>
                </a>
            </div>
            <div class="column-one-third over-hidden click3">
            <a href="{{ URL::to('services/High-School') }}">
                <div class="tileService">
                    <figure class="effect-ming">
                        <img src="{{ URL::asset('images/high.jpg') }}" alt="img09"/>
                        <figcaption>
                            <h2><span>High School</span></h2>
                            <p>
                                Tutoring services for high school students. Services focus on test preparation and advancing the problem-solving skills needed to excel and stand out from peers.
                            </p>
                            </figcaption>           
                    </figure>
                </div>
                </a>
            </div>
        </div>


        <div class="new_row title1">
            <div class="column-20">
                <p>The Ivy Key Guarantee</p>
            </div>
        </div>
        <div class="push_underlayer1">

            <div class="new_row">
                <div id="mid_text" class="column-12 col-border-top push-left-4">
                    <p>The Ivy Key Method® offers rigorous coursework manner similar to an Ivy League education. Our courses detail key concepts and deliver "buckets of knowledge" to help students master their subjects and our courses use a top-down approach in order to develop students' analytical skills.
                    
                        The Ivy Key guarantees that students who follow The Ivy Key Method® will increase their overall score. Students who are unsatisfied with their results can receive free tutoring from an Ivy Key tutor.
                    </p>
                </div>
            </div>

            <div class="new_row img_pad">
                <div class="column-5-5 push-left-4 elems-center" data-uk-scrollspy="{cls:'uk-animation-scale-up', repeat: true}">
                    <div class="testimonials-img-box">
                        <img src="<?php echo 'images/users/' . $testims[0]->photoURL; ?>" class="img_init" alt="">
                        <img src="{{ URL::asset('images/mask.png') }}" class="img_init testimonials-img-mask" alt="">
                    </div>
                </div>
                <div class="column-5-5 push-right-4 elems-center" data-uk-scrollspy="{cls:'uk-animation-scale-up',delay:300, repeat: true}">
                    <div class="testimonials-img-box">
                        <img src="<?php echo 'images/users/' . $testims[1]->photoURL; ?>" class="img_init" alt="">
                        <img src="{{ URL::asset('images/mask.png') }}" class="img_init testimonials-img-mask" alt="">
                    </div>
                </div>
            </div>
            <div class="new_row">
                <div class="column-5-5 push-left-4 elems-center title2">
                    <p><?php echo strtoupper($testims[0]->name); ?></p>
                </div>
                <div class="column-5-5 push-right-4 elems-center title2">
                    <p><?php echo strtoupper($testims[1]->name); ?></p>
                </div>
            </div>
            <div class="new_row">
                <div id="rev_text_1" class="column-5-5 push-left-4 elems-left" data-uk-scrollspy="{cls:'uk-animation-slide-left', repeat: true}">
                    <p>"<?php echo $testims[0]->testimonial; ?>"</p>
                </div>
                <div id="rev_text_1" class="column-5-5 push-right-4 elems-left" data-uk-scrollspy="{cls:'uk-animation-slide-right', repeat: true}">
                    <p>"<?php echo $testims[1]->testimonial; ?>"</p>
                </div>
            </div>

            @include('partials.slider')
        </div>
    </div>
    @include('partials.findtutorprogram')

<script>
    $(document).ready(function(){
        document.title = 'The Ivy Key - Services';

        $('.row-fixed-content').addClass('tutors-top-content');
    });
</script>
@stop