<?php 

   $studentNotif = array(
      'the_ivy_key_newsletter' => '0',
      'promotion' => '0',
      'new_course' => '0'
    );

   $notifs_trans = array(
        'The Ivy Key newsletter',
        'Promotional prices',
        'Promotion of new courses',
    );

?>

<!DOCTYPE html>
<html lang="en">
<head>
	<title>The Ivy Key - Register</title>
	<link rel="shortcut icon" href="/images/favicon.ico" type="image/x-icon">
	<link rel="stylesheet" type="text/css" href="http://yui.yahooapis.com/3.18.1/build/cssreset/cssreset-min.css">
	<link rel="stylesheet" href="{{ URL::asset('uikit/css/uikit.gradient.css') }}">
	<link rel="stylesheet" href="{{ URL::asset('uikit/css/addons/uikit.addons.min.css') }}">
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Open+Sans:300,300italic,400,600,700">
	<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Playfair+Display:400,700">
	<link rel="stylesheet" href="{{ URL::asset('css/register/style.css') }}">
	<script type="text/javascript" src="{{ URL::asset('js/jquery.js') }}"></script>
	<script type="text/javascript" src="{{ URL::asset('uikit/js/uikit.min.js') }}"></script>
	<script type="text/javascript" src="{{ URL::asset('uikit/js/addons/upload.min.js') }}"></script>
	<script type="text/javascript" src="{{ URL::asset('uikit/js/addons/datepicker.min.js') }}"></script>
	<script type="text/javascript" src="{{ URL::asset('/js/register/main.js') }}"></script>
</head>
<body>

<div id="breadcrumb">
	<img id="menuButton" src="{{ URL::asset('/images/register/images/icons/menu.png') }}"/>
    <div id="breadcrumb_text"><span>Register</span></div>
</div>

<div id="content">

    <div id="profile_left_column">
        <img id="profile_image" class="uk-border-circle" src="{{ URL::asset('images/no-profile-image.png') }}"/>
        <div class="button profile_button_image">
            <a href="#modal" data-uk-modal>Change profile picture</a>
        </div>
    </div>

    <div id="modal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div id="upload-drop" class="uk-placeholder uk-text-center">
                <i class="uk-icon-cloud-upload uk-icon-medium uk-text-muted uk-margin-small-right"></i>
                Drop here new profile picture or <a class="uk-form-file"><button class="uk-button">Select image</button>
                    <input type="file" id="upload-select" name="studentPhoto"/></a>
            </div>

            <div id="progressbar" class="uk-progress uk-hidden">
                <div class="uk-progress-bar" style="width: 0%;">...</div>
            </div>
        </div>
    </div>

<div id="profile_center_column">

    {!! Form::open(['url' => '/ivykey/users', 'id' => 'registerForm']) !!}

        @if(count($errors) > 0)
            <div class="alert-box">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
         
        <div id="profil_center_left">
            <input type="hidden" name="photo" value="">

            <label for="first_name">First name</label>
            <input type="text" id="first_name" name="first_name" value=""/>

            <label for="last_name">Last name</label>
            <input type="text" id="last_name" name="last_name" value=""/>

            <label for="grade_id">Grade</label>
            {!! Form::select('grade_id', $grades, 0) !!}

            <label for="school_id">School</label>
            {!! Form::select('school_id', $schools, 0) !!}
            
            <label for="course_id">Course</label>
            {!! Form::select('course_id', $programs, 0) !!}


            <label for="address">Address</label>
            <input type="text" id="address" name="address" value=""/>

            <label for="city">City</label>
            <input type="text" id="city" name="city" value=""/>

            <label for="zip">ZIP code</label>
            <input type="text" id="zip_code" name="zip" value=""/>

            <label for="state">State</label>
            <input type="text" id="state" name="state" value="" />

            <label for="country">Country</label>
            <input type="text" id="country" name="country" value=""/>

            <input type="hidden" name="_token" value="{{ csrf_token() }}">



        </div>

        <div id="profil_center_right">

            <label for="home_phone">Home Phone</label>
            <input type="text" id="phone" name="home_phone" value=""/>

            <label for="parent_phone">Parent Phone</label>
            <input type="text" id="parent_phone" name="parent_phone" value=""/>

            <label for="email">Student E-mail</label>
            <input type="text" id="studentEmail" name="email" value=""/>

            <label for="parentEmail">Parent E-mail</label>
            <input type="text" id="parentEmail" name="parent_email" value=""/>

            <label for="username">Username</label>
            <input type="text" id="user_name" name="username" value=""/>

            <label for="password">Password</label>
            <input type="password" id="password" name="password" value=""/>

            <label for="password_confirmation">Re-type Password</label>
            <input type="password" id="repassword" name="password_confirmation" value=""/>

            <label style="margin-top: 50px;">E-mail notifications</label>

            <div id="checkBox">

                <?php 
                	$i = 0;

                	foreach ($studentNotif as $key => $value) :

                ?>

                    <label class="labelNotif">

                        <input type="checkbox" class="chkbox" name="<?php echo $key; ?>" <?php echo (($value) ? 'checked' : ''); ?>/>
                        <span><?php echo $notifs_trans[$i]; ?></span></label>

		        <?php 
		        	$i++;

    				endforeach;

    			?>

            </div>
            <div class="button2"><input type="submit" id="profile_submit" name="submit" value ="Register profile"></div>
        </div>

    {!! Form::close() !!}
</div>

    <div id="modalLoad" class="uk-modal">
        <div class="uk-modal-dialog modalLoad-dialog">
            <img src="{{ URL::asset('images/register/images/loading.gif') }}"/>
        </div>
    </div>

    <div id="modalConfirm" class="uk-modal">
        <div class="uk-modal-dialog">
        	<a class="uk-modal-close uk-close"></a>
    		<img src="{{ URL::asset('images/register/images/check-icon.png') }}"><p>Your profile is created. Please, login to portal on front page.</p>
    	</div>

    </div>

</div>

</div>
<footer>
    <div id="logo">
    	<img src="{{ URL::asset('images/logo.png') }}" alt="The Ivy Key" id="logoimg">
	</div>

    <div id="soc_icons">
        <a href="https://www.facebook.com/theivykey" target="_blank" class="uk-icon-facebook soc-border"></a>
        <a href="http://www.twitter.com/theivykey" target="_blank" class="uk-icon-twitter soc-border"></a>
        <a href="https://www.youtube.com/user/TheIvyKey/videos" target="_blank" class="uk-icon-youtube soc-border"></a>
        <a href="/ivykeyportal/aboutus/#contactus" class="uk-icon-phone soc-border"></a>
        <a href="/ivykeyportal/aboutus/#contactus" class="uk-icon-envelope-o soc-border"></a>
    </div>
    <p>© Copyright 2014 The Ivy Key. LLC. All Rights Reserved</p>
</footer>

<script>
	$(document).ready(function(){
		document.title = 'The Ivy Key - Register';

        $( "#gradeChange" ).change(function () {

            var grade = $("#gradeChange").val();

            $("#schoolChange").val([]);

            $.ajax({
                type: "POST",
                url: "{{ URL::to('/register/schoolChange') }}",
                data: { data : grade },
                success: function(data) {
                    $("#schoolChange").empty().append(data);
                }
            });

    });
	});
</script>
</body>
</html>