@extends('master')

@section('content')
<script src='https://www.google.com/recaptcha/api.js'></script>
<style> iframe { display: block !important;} .g-recaptcha { margin-top: 30px;} .g-recaptcha div>div {margin:auto;}</style>
</script>
<div class="new_row">
    <div class="column-15 push-left-3 top_space_tutors"></div>
</div>
<div class="new_row row-fixed">
    <div class="column-20">
        <img src="{{ URL::asset('images/profile_top.jpg') }}" alt="">
    </div>
</div>

<div class="new_row row-background-filled profile-content-bottom" style="margin-bottom: 3vw;">
    <div class="column-6 push-left-4 tutors-list">
        <div class="new_row">
            <div class="column-7">
                @foreach($tutor as $tut)
                	@if($tut->photoURL == '')
						<img src="{{ URL::asset('images/no-profile-image.png') }}" alt="">
                	@else
						<img src="{{ URL::asset('images/users/') . '/' . $tut->photoURL }}" alt="">
                	@endif 
            </div>
            <div class="column-13 profile-name">
                <p class="name"><?php echo strtoupper($tut->name); ?></p>
            </div>
        </div>
        <hr>
        <div class="new_row">
            <div class="column-20 profile-description">
                <span>Location: </span>{{ $tut->location }}<br/>
                <span>University: </span>{{ $tut->university }}<br/>
                
                <span>Subject: </span>{{  $tut->subject }}
                <br/><br/><br/>
                @if(trim($tut->about) != '')
                <span>About {{ $tut->name }}</span><br/>{{ $tut->about }}
                @endif
                
            </div>
    	</div>
	</div>
</div>

<div class="column-1 push-left-4 empty"></div>
<div class="column-5 push-left-4 request-tutoring" style="float: none;">
    <div class="request-title">
        <p>Get Started</p>
        <p>REQUEST TUTORING</p>
    </div>
    <div class="request-content" style="background-color: #f2f2f2;margin-bottom: 2vw;">
        <form id="reqForm" action="/sendrequest	" method="post" accept-charset="utf-8">
            <input type="hidden" name="tutor" value="<?php echo strtoupper($tut->name); ?>">
            <input id="name" type="text" name="name" placeholder="Name">
            <input id="email" type="text" name="email" placeholder="Email">
            <input id="phone" type="text" name="phone" placeholder="Phone">
            <input id="zip" type="text" name="zip" placeholder="Zip">
            <p>Are you a parent or a student?</p>
            <div class="radio fl-left">
                <input type="radio" name="requester" id="request-parent" value="parent" checked>
                <label for="request-parent">parent</label>
            </div>
            <div class="radio fl-left">
                <input type="radio" name="requester" id="request-student" value="student">
                <label for="request-student">student</label>
            </div>

            <p class="areaTxt">Additional Comments</p>
            <textarea name="comments"></textarea> 

            <div class="g-recaptcha" data-sitekey="6LdtV_oSAAAAABXD3uNFy_rCbqRuYVB2MX5SCXHD"></div>

            <input class="request-submit" type="submit" value="Submit">
        </form>
    </div>
</div>
@endforeach


@stop