@extends('master')

@section('content')
<style>
    @font-face {
        font-family: 'Helvetica-Neue';
        url: 'assets/fonts/HelveticaNeue.ttf';
    }
    .top-payment{
        margin-top: 17vw;
    }
    
    .payments {
        width: 100%;
        height: 50px;
        border-bottom: 1px solid #dee2e5;
        padding-bottom: 15px;
    }

    .payments button {
        float: left;
        margin: 0 5px;
        outline: none;
        border: none;
        border-radius: 5px;
        height: 40px;
    }

    .paypal button {
        width: 100px;
        background: #DCE9D7;
    }

    .coinbase button {
        width: 120px;
        background: #DCE9D7;
    }
    
    .field-name {
        color: #6e787f;
        font-size: 12px;
        position: absolute;
        left: 14px;
        top: 14px;
        display: block;
        opacity: 0;
        -webkit-transform: translate3d(0, 6px, 0);
        -moz-transform: translate3d(0, 6px, 0);
        -ms-transform: translate3d(0, 6px, 0);
        -o-transform: translate3d(0, 6px, 0);
        transform: translate3d(0, 6px, 0);
        -webkit-transition: -webkit-transform 111ms ease-out, opacity 111ms ease-out;
        -moz-transition: -moz-transform 111ms ease-out, opacity 111ms ease-out;
        -o-transition: -o-transform 111ms ease-out, opacity 111ms ease-out;
        transition: transform 111ms ease-out, opacity 111ms ease-out;
    }

    #payment-form {
        width: 100%;
    }

    #payment-form label {
        float: left;
        padding-left: 5px;
        display: none;
        position: absolute;
        z-index: 99999;
        left: 5px;
    }

    #payment-form input {
        display: block;
        width: 100%;
        font-weight: 200;
        font-size: 16px;
        color: #d3d3d3;
        /*margin: 35px 0 0 0;*/
        padding: 40px 14px 25px;
        outline: none;
        border: none;
        border-bottom: 1px solid #dee2e5;
        font-family: "Helvetica-Neue", "HelveticaNeue-Light", "Helvetica Neue Light", "Helvetica Neue", Helvetica, Arial, "Lucida Grande", sans-serif;
        font-weight: 300;
        font-size: 16px;
        color: #283036;
    }
    
    #payment-form ::-webkit-input-placeholder { color: #000; }
    #payment-form ::-moz-input-placeholder { color: #000; }
    #payment-form :-moz-input-placeholder { color: #000; }

    
    #payment-form input
        :-moz-placeholder {
            color: #000;
        }

    .active {
        background: #f9f9f9;
        color: #000;
        overflow: hidden;
        -webkit-transition: background-color 131ms linear;
        -moz-transition: background-color 131ms linear;
        -o-transition: background-color 131ms linear;
        transition: background-color 131ms linear;
    }

    .alert-message {
        position: fixed;
        min-width: 250px;
        min-height: 80px;
        border: 1px solid #861E1E;
        border-radius: 5px;
        background: #DC5C5C;
        text-align: center;
        padding: 32px;
        bottom: 50px;
        right: 50px;
        z-index: 99999;
        display: none;                                    
    }

</style>

@if(session('message'))
    <div class="alert-message">
        {{ session('message') }}
    </div>
@endif
<div class="new_row">
    <div class="column-15 top_space_tutors">
        <div class="large_top_icon_tutors">
            <div class="large_top_text">Payment</div>

        </div>
    </div>
    
    <div class="new_row row-fixed">
        <div class="column-20">
            <img src="{{ URL::asset('images/girl2.jpg') }}" alt="">
        </div>
    </div>

    <div class="new_row top-payment">
        <div class="column-5"></div>
        <div class="column-10">
            <div class="payments">
                <div class="paypal"><button>PayPal</button></div>
                <div class="coinbase"><button>coinbase</button></div>
            </div><br><br>
            <form id="checkout" method="post" action="{{ URL::to('/payment') }}">
                <div id="payment-form">
                    <span class="field-name">Card Number</span>
                @if(! Auth::check())
                    <h3>We need some of your info</h3>
                    <label for="first_name">Student first name</label>
                    <input type="text" name="first_name" placeholder="Student First Name" value="{{ \Input::get('first_name') }}"><br>

                    <label for="last_name">Student last name</label>
                    <input type="text" name="last_name" placeholder="Student Last Name" value="{{ Input::get('last_name') }}"><br>

                    <label for="email">Student email</label>
                    <input type="email" name="email" placeholder="Student Email" value="{{ Input::get('email') }}"><br>

                    <label for="username">Username</label>
                    <input type="text" name="username" placeholder="Username" value="{{ Input::get('username') }}">
                    
                    <label for="parent_email">Parent email</label>
                    <input type="text" name="parent_email" placeholder="Parent email" value="{{ Input::get('parent_email') }}">

                    <label for="parent_phone">Parent phone number</label>
                    <input type="text" name="parent_phone" placeholder="Parent phone number" value="{{ Input::get('parent_phone') }}">

                    <label for="password">Password</label>
                    <input type="password" name="password" placeholder="Choose password">
                    
                    <label for="password_confirmation">Repeat password</label>
                    <input type="password" name="password_confirmation" placeholder="Repeat passwrod">

                @endif
                    <input type="hidden" name="program" value="{{ $_GET['program'] }}">
                    <h3>Credit Card</h3>

                    <label for="cc-number">Card number</label>
                    <input type="text" name="cc-number" id="cc-number" placeholder="Card Number" inputmode="numeric"><br>

                    <label for="exp-date">Expiration date</label>
                    <input type="text" name="exp-date" id="exp-date" placeholder="Expiration Date" maxlength="7"> <br><br>
                    
                    <input type="hidden" name="_token" value="{{ csrf_token() }}">
                </div>
                
                <input type="submit" value="Pay">
            </form>
        </div>
    </div>
    
      @include('partials.findtutorprogram')
</div>
<script>
$(document).ready(function(){

jQuery.fn.numericOnly = function()
{
    return this.each(function()
    {
        $(this).keydown(function(e)
        {
            var key = e.charCode || e.keyCode || 0;            
            return (
                key == 8 || 
                key == 9 ||
                key == 46 || 
                (key >= 37 && key <= 40) ||
                (key >= 48 && key <= 57) ||
                (key >= 96 && key <= 105));
        });
    });
};

    $('.alert-message').fadeIn().delay(5000).fadeOut();

    // show labels
    $('#payment-form>input').on('keydown', function(){
        $('label[for='+ $(this).attr("name") + ']').fadeIn();
    });

    // hide labels
    $('#payment-form>input').on('keyup', function(){
        if(! $(this).val()) 
        {
            $('label[for='+ $(this).attr("name") + ']').fadeOut();
        }
    });

    // $('#cc-number, #exp-date').numericOnly();

    $("#exp-date").keyup(function(e){
        if ($(this).val().length == 2 && e.keyCode !== 8){
            $(this).val($(this).val() + " / ");
        }else if ($(this).val().length == 5){
            $(this).val($(this).val() + "");
        }
    });

    var hide = true;

    $('#payment-form>input').on('click', function(){
        $('#payment-form>input').removeClass('active');
        $(this).addClass('active');

        hide = false;
    });

    $('html').on('click', function(){
        if(hide) {
            $('#payment-form>input').removeClass('active');
        }
        
        hide = true;
    });

    $('.row-fixed-content').addClass('profile-top-content');

});
</script>

@stop