@extends('ivykey.master')

@section('content')
<div id="breadcrumb" class="breadcrumb_messages">
    <img id="menuButton" src="{{ URL::asset('/images/register/images/icons/menu.png') }}"/>
    <div id="breadcrumb_text"><span>Notes</span></div>
</div>
<div class="content">
    <style>
	#notes-content {
		padding: 20px;
		padding-left: 10vw;
		padding-right: 10vw;
	}

	.note {
	    min-height:150px;
	    padding:10px;
	    padding-bottom: 30px;
	    width:150px;
	    position:absolute;
	    overflow:hidden;
	    cursor:move;

	    font-family:'Open Sans',sans-serif;
	    font-size:16px;

	    /* Adding a CSS3 shadow below the note, in the browsers which support it: */
	    -moz-box-shadow:2px 2px 0 #DDDDDD;
	    -webkit-box-shadow:2px 2px 0 #DDDDDD;
	    box-shadow:2px 2px 0 #DDDDDD;
	}

#fancy_ajax .note{ cursor:default; }

/* Three styles for the notes: */

.yellow{
    background-color:#FDFB8C;
    border:1px solid #DEDC65;
}

.blue{
    background-color:#A6E3FC;
    border:1px solid #75C5E7;
}

.green{
    background-color:#A5F88B;
    border:1px solid #98E775;
}

.orange{
    background-color:#FFDB67;
    border:1px solid #FCBF50;
}

.purple{
    background-color:#E3D4E5;
    border:1px solid #D3AED7;
}

.red{
    background-color:#FFD2D2;
    border:1px solid #FAAEAE;
}

.grey{
    background-color:#E0E0E0;
    border:1px solid #CBCBCB;
}

/* Each note has a data span, which holds its ID */
span.data{ display:none; }

/* The "Add a note" button: */
#addButton{
    
}
a.green-button,a.green-button:visited{
    color:black;
    display:block;
    font-size:10px;
    font-weight:bold;
    height:15px;
    padding:6px 5px 4px;
    text-align:center;
    width:60px;

    text-shadow:1px 1px 1px #DDDDDD;
    background:url(../images/button_green.png) no-repeat left top;
}

a.green-button:hover{
    text-decoration:none;
    background-position:left bottom;
}

.author{
    /* The author name on the note: */
    bottom:10px;
    color:#666666;
    font-family:Arial,Verdana,sans-serif;
    font-size:12px;
    position:absolute;
    right:10px;
}

#main{
    /* Contains all the notes and limits their movement: */
    margin:0 auto;
    position:relative;
    /*width:980px;*/
    height:700px;
    z-index:10;
    /*background:url(../assets/Front/images/add_a_note_help.gif) no-repeat left top;*/
}
h3.popupTitle{
    border-bottom:1px solid #DDDDDD;
    color:#666666;
    font-size:24px;
    font-weight:normal;
    padding:0 0 5px;
}

#noteData{
    /* The input form in the pop-up: */
    height:200px;
    margin:30px 0 0 200px;
    width:350px;
}

.note-form label{
    display:block;
    font-size:10px;
    font-weight:bold;
    letter-spacing:1px;
    text-transform:uppercase;
    padding-bottom:3px;
}

.note-form textarea, .note-form input[type=text]{
    background-color:#FCFCFC;
    border:1px solid #AAAAAA;
    font-family:Arial,Verdana,sans-serif;
    font-size:16px;
    height:60px;
    padding:5px;
    width:300px;
    margin-bottom:10px;
}

.note-form input[type=text]{	height:auto; }

.color{
    /* The color swatches in the form: */
    cursor:pointer;
    float:left;
    height:10px;
    margin:0 5px 0 0;
    width:10px;
}
.note img {
	width: 20px;
  position: absolute;
  z-index: 10000;
  bottom: 5px;
  left: 5px;
  cursor: pointer;
  opacity: .6;
}

#note-submit{	margin:20px auto; }

</style>
<link rel='stylesheet' href="{{ URL::asset('fancybox/jquery.fancybox-1.2.6.css') }}" />

<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4.1/jquery.min.js"></script>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/jquery-ui.min.js"></script>
<script type="text/javascript" src="{{ URL::asset('fancybox/jquery.fancybox-1.2.6.pack.js') }}"></script>
<script type="text/javascript" src="{{ URL::asset('fancybox/script.js') }}"></script>

@if(Auth::check())
<a id="addButton" class="buttonAddNote" href="{{ URL::to('/ivykey/dashboard/notes/addNote') }}">Add a note</a>
@endif

<div id="notes-content">

<?php
	$notes = '';
	foreach ($allNotes as $note) {
			list($left, $top, $zindex) = explode('x', $note->xyz);

			$notes .= '
				<div class="note '.$note->color.'" style="left:'.$left.'vw;top:'.$top.'vh;	z-index:'.$zindex.'">
        		'.htmlspecialchars($note->text).'
        		<div class="author">'.htmlspecialchars($note->title).'</div>
        		<span class="data">'.$note->id.'</span>
        		<img onClick="deleteNote('.$note->id.')" src="' .\URL::asset("images/deleteNotes.png"). '">
    		</div>';
		}

?>

<div id="main">
	<?php echo $notes?>
	<input type="hidden" name="_token" value="{{ csrf_token() }}">
</div>

</div>
</div>
</div>
@stop