<style>
	.message {
		position: fixed;
        min-width: 200px;
        min-height: 20px;
        border: 1px solid #861E1E;
        border-radius: 5px;
        background: #29FFD8;
        text-align: center;
        padding: 32px;
        bottom: 50px;
        right: 50px;
        font-size: 16px;
        font-weight: 600;
        z-index: 99999;
        display: none;
	}
</style>
@extends('ivykey.master')

@section('content')
@if(session('message'))
	<div class="message">
		{{ session('message') }}
	</div>
@endif
<div id="breadcrumb" class="breadcrumb_messages">
    <img id="menuButton" src="{{ URL::asset('images/icons/profile-burger.png') }}"/>
    <div id="breadcrumb_text"><span>Profile</span></div>
</div>
<div class="content">
    <div id="profile_left_column">
    @if(Auth::user()->photoURL == '')
        <img id="profile_image" class="uk-border-circle" src="{{ URL::asset('images/no-profile-image.png') }}"/>
    @else
        <img id="profile_image" class="uk-border-circle" src="{{ URL::asset('images/') . '/' . Auth::user()->photoURL }}" alt="">
    @endif
        <div class="button3 profile_button_image">
            <a href="#modal" data-uk-modal>Change profile picture</a>
        </div>
    </div>

    <div id="modal" class="uk-modal">
        <div class="uk-modal-dialog">
            <div id="upload-drop" class="uk-placeholder uk-text-center">
                <i class="uk-icon-cloud-upload uk-icon-medium uk-text-muted uk-margin-small-right"></i>
                Drop here new profile picture or <a class="uk-form-file"><button class="uk-button">Select image</button>
                    <input type="file" id="upload-select" name="studentPhoto"/></a>
            </div>

            <div id="progressbar" class="uk-progress uk-hidden">
                <div class="uk-progress-bar" style="width: 0%;">...</div>
            </div>
        </div>
    </div>

<div id="profile_center_column">
<?php

$studentNotif = array(
	'the_ivy_key_newsletter' => '0',
	'promotion' => '0',
	'new_course' => '0'
);

$notifs_trans = array(
    'The Ivy Key newsletter',
    'Promotional prices',
    'Promotion of new courses',
);

?>
    {!! Form::open(array('method' => 'PUT', 'url' => '/ivykey/users', 'id' => 'registerForm')) !!}
        <div id="profil_center_left">
            <input type="hidden" name="photo" value="">

            <label for="first_name">First name</label>
            <input type="text" id="first_name" name="first_name" value="{{ Auth::user()->first_name }}"/>

            <label for="last_name">Last name</label>
            <input type="text" id="last_name" name="last_name" value="{{ Auth::user()->last_name }}"/>

            <label for="grade_id">Grade</label>
            <label class="m-down">
            {!! Form::select('grade_id', $grades, Auth::user()->grade_id) !!} 
            </label>

            <label for="school_id">School</label>
            <label class="m-down">
            {!! Form::select('school_id', $schools, Auth::user()->school_id) !!}
            </label>

            <label for="course_id">Course</label>
            <label class="m-down">
            {!! Form::select('course_id', $programs, Auth::user()->course_id) !!}
            </label>

            <label for="address">Address</label>
            <input type="text" id="address" name="address" value="{{ Auth::user()->address }}"/>

            <label for="city">City</label>
            <input type="text" id="city" name="city" value="{{ Auth::user()->city }}"/>

            <label for="zip">ZIP code</label>
            <input type="text" id="zip_code" name="zip" value="{{ Auth::user()->zip }}"/>

            <label for="state">State</label>
            <input type="text" id="state" name="state" value="{{ Auth::user()->state }}" />

            <label for="country">Country</label>
            <input type="text" id="country" name="country" value="{{ Auth::user()->country }}"/>

            <input type="hidden" name="_token" value="{{ csrf_token() }}">

        </div>

        <div id="profil_center_right">

            <label for="home_phone">Home Phone</label>
            <input type="text" id="phone" name="home_phone" value="{{ Auth::user()->home_phone }}"/>

            <label for="parent_phone">Parent Phone</label>
            <input type="text" id="parent_phone" name="parent_phone" value="{{ Auth::user()->parent_phone }}"/>

            <label for="email">Student E-mail</label>
            <input type="text" id="studentEmail" name="email" value="{{ Auth::user()->email }}"/>

            <label for="parentEmail">Parent E-mail</label>
            <input type="text" id="parentEmail" name="parent_email" value="{{ Auth::user()->parent_email }}"/>

            <label for="username">Username</label>
            <input type="text" id="user_name" name="username" value="{{ Auth::user()->username }}"/>

            <label for="password">Password</label>
            <input type="password" id="password" name="password" value=""/>

            <label for="password_confirmation">Re-type Password</label>
            <input type="password" id="repassword" name="password_confirmation" value=""/>

            <label style="margin-top: 50px;">E-mail notifications</label>

            <div id="acaBox">
                <!-- Za brisanje samo primer -->
                <input type="checkbox" id="cb1" name="cb" value="">
                <label for="cb1">The Ivy Key newsletter</label><br>
                <input type="checkbox" id="cb2" name="cb"value="" checked>
                <label for="cb2">New message from support</label><br>
                <input type="checkbox" id="cb3" name="cb" value="">
                <label for="cb3">Promotional prices</label>
                <input type="checkbox" id="cb4" name="cb" value="">
                <label for="cb4">Promotion of new courses</label>
                <?php 
                	//$i = 0;
                	//foreach ($studentNotif as $key => $value) :
                ?>
                    <!-- <label class="labelNotif"> -->
                        <!-- <input type="checkbox" class="chkbox" name="<?php //echo $key; ?>" <?php //echo (($value) ? 'checked' : ''); ?>/> -->
                        <!-- <span><?php //echo $notifs_trans[$i]; ?></span></label> -->
		        <?php 
		        	//$i++;
    				//endforeach;
    			?>
            </div>
            <div class="button2"><input type="submit" id="profile_submit" name="submit" value="Update profile"></div>
        </div>

	{!! Form::close() !!}
</div>

    <div id="modalLoad" class="uk-modal">
        <div class="uk-modal-dialog modalLoad-dialog">
            <img src="{{ URL::asset('images/register/images/loading.gif') }}"/>
        </div>
    </div>

    <div id="modalConfirm" class="uk-modal">
        <div class="uk-modal-dialog">
        	<a class="uk-modal-close uk-close"></a>
    		<img src="{{ URL::asset('images/register/images/check-icon.png') }}"><p>Your profile is created. Please, login to portal on front page.</p>
    	</div>

    </div>

</div>
</div>

<script>
    $(document).ready(function(){
        document.title = 'The Ivy Key - Dashboard';

        $('.message').fadeIn().delay(3000).fadeOut();
    });
</script>
@stop
