@extends('ivykey.master')

@section('content')
<div id="breadcrumb" class="breadcrumb_messages">
    <img id="menuButton" src="{{ URL::asset('/images/register/images/icons/menu.png') }}"/>
    <div id="breadcrumb_text"><span>Calendar</span></div>
</div>
<style>
	#calendar-content {
		min-height: 875px;
		padding: 20px;
		padding-left: 10vw;
		padding-right: 10vw;
	}

	.fc-center h2{
		font-size: 30px;
		color: #1b7800;
		font-family: 'Open Sans', serif;
	}
	.fc-widget-header {
		background-color: #1b7800;
		color: #fff;
	}
	.fc-widget-header tr{
		height: 35px;
	}
	.fc-widget-header th{
		vertical-align: middle !important;
		font-size: 18px;
	}
	td.fc-day-number {
		font-size: 16px;
		color: #1b7800;
		font-weight: 500;
	}
	.fc-day-number.fc-other-month {
		opacity: 0.5 !important;
	}
	.group_selection_box {
		margin-bottom: 15px;
	}
	.group_selection_box select {
		border: 1px solid #1b7800;
	}
	.group_selection_box span {
		color: #1b7800;
		font-weight: 500;
	}
	.group_selection_box option {
		color: #1b7800;
	}
	.fc-content {
		height: 30px;
		background-color: #1b7800;
	}
</style>
<link rel='stylesheet' href="{{ URL::asset('css/fullcalendar.css') }}" />
<script src="{{ URL::asset('js/moment.min.js') }}"></script>
<script src="{{ URL::asset('js/fullcalendar.min.js') }}"></script>

<div id="calendar-content">
	<div class="group_selection_box">
	<span>Select group: </span>
	<select>
		@foreach ($groups as $grp)
			echo '<option value="'.$grp['ID_groups'].'">' . $grp['name'] . '</option>';
		@endforeach
	</select>
</div>
	<div id="calendar"></div>

</div>



<script>
$(document).ready(function() {

	$.group_id = <?php echo $group_id;?>    

    $('#calendar').fullCalendar({
        header: {
				left: 'prev,next today',
				center: 'title',
				right: 'month,agendaWeek'
			},
			height: 750,
			allDay: false,
			events: {
       url: '../Ajax/list_group_and_schedule?g=' + $.group_id,
            type: 'POST', // Send post data
            error: function() {
                alert('There was an error while fetching events.');
            }
    }
    });

    $( "select" ).change(function () {
    	$('#calendar').fullCalendar('destroy');
	    $('#calendar').fullCalendar({
	        header: {
					left: 'prev,next today',
					center: 'title',
					right: 'month,agendaWeek'
				},
				height: 750,
				allDay: false,
				events: {
	       url: '../Ajax/list_group_and_schedule?g=' + $( "select option:selected" ).val(),
	            type: 'POST', // Send post data
	            error: function() {
	                alert('There was an error while fetching events.');
	            }
	    }
	    });

	});
});
</script>
@stop