@extends('cms.master')

@section('content')
<nav class="uk-navbar uk-navbar-attached" data-uk-sticky data-uk-scrollspy-nav="{closest:'li'}" >
    <ul class="uk-navbar-nav">
        
    @foreach($courses as $course)           
        <li<?php echo ($course->id == $default_course) ? ' class="uk-active"' : '';?>>
            <a href="{{ URL::to('/cms/programs'). '/' .$course->id }}">
                <div class="uk-icon-calendar top-menu-icon"></div>
                <?php echo $course->name; 
                if($course->id == $default_course) $title = $course->name;?>
            </a>
        </li>       
    @endforeach
        
    </ul>
</nav>

<div class="uk-grid cms-page-content">
    <div class="uk-width-1-1 page-title">       
        <p><?php echo $title . ' '; ?>program</p><a class="uk-button uk-button-primary" href="{{ URL::to('/cms/programs/add-program') }}"><div class="uk-icon-plus-square top-menu-icon"></div>Add Program</a>
        <br/><br/><hr/>       
    </div>
                        
    <div class="uk-width-1-1">
        @if(count($programs) == 0)
            <div class="no-programs-notification"><p>No programs yet!</p></div>
        @endif
        <table class="tutor-table uk-table">
            <thead>
                <tr>
                    <th>ID<a href="Tutors/sortToggle" data-uk-tooltip title="Toggle Sort"><div id="id" class="uk-icon-sort-numeric-asc sort-active"></div></a></th>
                    <th>Type</th>
                    <th>Start date</th>
                    <th>Prep for exam</th>
                    <th>Meets on<a href="Tutors/sortFirstNameDesc" data-uk-tooltip title="Toggle Sort"><div id="first_name" class="uk-icon-sort-alpha-asc"></div></th>
                    <th>Location<a href="Tutors/sortLastNameDesc" data-uk-tooltip title="Toggle Sort"><div id="last_name" class="uk-icon-sort-alpha-asc"></div></th>
                    <th>Instructor<a href="Tutors/sortLocationDesc" data-uk-tooltip title="Toggle Sort"><div id="university" class="uk-icon-sort-alpha-asc"></div></th>
                    <th class="uk-text-center">Enrollment</th>
                    <th class="uk-text-center">Schedule</th>
                    <th class="uk-text-center">Action</th>
                </tr>
            </thead>
            <tbody>
            @foreach ($programs as $prog)
     
                <tr class="uk-table-middle">
                    <td>{{ $prog->id }}</td>
                    <td>{{ $prog->type }}</td>
                    <td>{{ $prog->startDate }}</td>
                    <td>{{ $prog->forExam }}</td>
                    <td>{{ $prog->meetsOn }}</td>
                    <td>{{ $prog->schoolName }}</td>
                    <td>{{ $prog->firstName }} {{ $prog->lastName }}</td>
                    <td class="uk-text-center"><form class="uk-form"><input type="checkbox" onclick="toggleEnrollment(this, <?php echo $prog->id; ?>)" name="<?= $prog->id; ?>" <?php echo ($prog->active) ? 'checked':''; ?>></form></td>
					<input type="hidden" name="_token" value="{{ csrf_token() }}">
                    <td class="uk-text-center">
                        <a class="uk-button uk-button-success edit-icon" href="<?php echo URL::to('/cms/programs/edit/').$prog->id; ?>" data-uk-tooltip title="Edit Schedule"><div class="uk-icon-calendar"></div></a>
                        <!--<a class="uk-button uk-button-danger" id="confirmDelete" href="<?php //echo URL::base().'Cms/Tutors/delete/'.$tutor->ID_user; ?>" onclick="return confirm();" data-uk-tooltip title="Delete"><div style="font-weight:bold;">X</div></a>-->
                    </td>
                    <td class="uk-text-center">
                        <a class="uk-button uk-button-success edit-icon" href="<?php echo URL::to('/cms/programs/edit/').$prog->id; ?>" data-uk-tooltip title="Edit"><div class="uk-icon-pencil"></div></a>
                        <!--<a class="uk-button uk-button-danger" id="confirmDelete" href="<?php //echo URL::base().'Cms/Tutors/delete/'.$tutor->ID_user; ?>" onclick="return confirm();" data-uk-tooltip title="Delete"><div style="font-weight:bold;">X</div></a>-->
                    </td>
                </tr>
                
            @endforeach
                
            </tbody>
        </table>
        <div id="dialog-confirm"></div>
        
    </div>
</div>
 
@stop