@extends('admin.administration')

@section('content')
<style>
	table {
		width: 98% !important;
		margin: 0 auto !important;
	}
	.pagination {
		margin: 10px 15px;
	}

	#excel {
	    border: none;
	    width: 70px;
	    height: 38px;
	    border-radius: 3px;
	    margin: 10px 15px;
	    background: #415F2A;
	    color: #fff;
	}

	#delst {
		border: none;
		background: none;
	}

	.remove_unit {
		font-size: 9px;
		cursor: pointer;
		color: #1D8EC7;
	}
</style>
	<div class="wrapper">
		<h5 class="widget-name"><br>
			<i class="icon-th"></i>Students
		</h5>
		<div class="depth"><a href="{{ URL::to('/admin/administration/manage-students/add-student') }}" title=""><i class="icon-plus"></i></a></div>Add New Student
		<div class="search">
			Search students: <input type="text" id="searchbox">
		</div>
	</div><br>
	<div class="table-overflow">
	<table class="table table-striped table-bordered">
		<thead>
		<tr>
			<th></th>
			<th>Firstname</th>
			<th>Lastname</th>
			<th>Email</th>
			<th>Assigned Classes</th>
			<th>Parent Email</th>
			<th></th>
			<th></th>
		</tr>
		</thead>
		<tbody id="fbody">
		@foreach($students as $student)
		<tr>
			@if($student->photoURL == '')
			<td class="table_user_image"><img src="{{ URL::asset('images/users/user.png') }}" class="usrimg" alt=""></td>
			@else
			<td class="table_user_image"><img src="{{ URL::asset('images/users/') .'/'.$student->photoURL }}" class="usrimg" alt=""></td>
			@endif
			<td>{{ $student->first_name }}</td>
			<td>{{ $student->last_name }}</td>
			<td>{{ $student->email }}</td>
			<td>
				@foreach($student->programs as $program)
					@if( !empty($program) )
						<strong>{{ $program->name }}</strong> ({{ $program->firstName . ' ' . $program->lastName }}) <span class="remove_unit" onclick="removeClass({{ $program->id }}, {{ $student->id }})">Remove</span><br>
					@else
						{{ '' }}
					@endif
				@endforeach
			</td>
			<td>{{ $student->parent_email }}</td>
			<td><a href="{{ URL::to('/') . '/admin/administration/manage-students/edit-student/'. $student->id }}"><i class="fam-pencil"></i></a></td>
			<td>
				<form action="{{ URL::to('/') . '/admin/administration/manage-students/delete-student/' . $student->id }}" method="post">
					<input type="hidden" name="_method" value="delete">
					<input type="hidden" name="_token" value="{{ csrf_token() }}">
					<button type="submit" id="delst"><i class="fam-cross"></i></button>
				</form>
			</td>
		</tr>
		@endforeach
		</tbody>
	</table>
	</div>
	<div class="pagination">{!! $students->render() !!}</div>
	<form action="{{ URL::to('/') . '/admin/administration/toExcel' }}" method="post">
		<input type="hidden" name="_token" value="{{ csrf_token() }}">
		<button id="excel">To Excel</button>
	</form>

<script>
$("#searchbox").keyup(function () {
	//split the current value of searchInput
	var data = this.value.split(" ");
	//create a jquery object of the rows
	var jo = $("#fbody").find("tr");
	if (this.value == "") {
	    jo.show();
	    return;
	}
	//hide all the rows
	jo.hide();

	//Recusively filter the jquery object to get results.
	jo.filter(function (i, v) {
	    var $t = $(this);
	    for (var d = 0; d < data.length; ++d) {
	        if ($t.is(":contains('" + data[d] + "')")) {
	            return true;
	        }
	    }
	    return false;
	})
	//show the rows that match.
	.show();
}).focus(function () {
	this.value = "";
	$(this).css({
	    "color": "black"
	});
	$(this).unbind('focus');
}).css({
	"color": "#C0C0C0"
});

function removeClass(programId, studentId) {

	$.post('/admin/administration/manage-students/removeClass', {'programId': programId, 'studentId': studentId, '_token': $('input[name=_token]').val(), '_method': 'delete' }, function(data){
		location.reload();
	});
}


</script>
@stop