@extends('admin.administration')

@section('content')
<style>
	table {
		width: 90% !important;
		/*margin: 0 50px;*/
	}
	#studentImg {
		width: 50px;
	}

	#delst {
		border: none;
		background: none;
	}

	.group-details {
		margin: 0 20px;
	}

	#tutorImg {
		border-radius: 25px;
		border: 1px solid #d3d3d3;
		margin-bottom: 5px;
	}
</style>
@foreach($group as $g)
	<div class="group-details">
		<h2>{{ $g->name }}</h2>

		<h4>Group details:</h4>

		Begin date: {{ $g->begin_date }} <br>
		End date: {{ $g->end_date }} <br>
		Course: {{ $g->courses->name }} <br>
		Location: {{ $g->schools->name }} <br><br>

		Tutor: {{ $g->tutors->first_name . ' ' . $g->tutors->last_name }}<br>
		<div class="tutor-image">
			<img src="{{ URL::asset('images') . '/users/' . $g->tutors->photoURL }}" id="tutorImg" alt="">
		</div>
		<a href="{{ URL::to('/admin/administration/manage-groups/edit/') . '/' . $g->id }}" class="btn btn-primary">Edit Group Info</a>
		<a href="" class="btn btn-primary">Group Schedule</a><br><br>

		<h2>Students:</h2>
		<table class="table table-striped table-bordered">
			<thead>
				<tr>
					<th></th>
					<th>Name</th>
					<th>Remove student</th>
				</tr>
			</thead>
			<tbody>
				@foreach($g->users as $student)
				<tr>
					<td width="50px">
						@if($student->photoURL != '')
						<img src="{{ URL::asset('/images/users/') . '/' . $student->photoURL }}" id="studentImg" alt="">
						@else
						<img src="{{ URL::asset('images/users/user.png')  }}" id="studentImg" alt="">
						@endif
					</td>
					<td width="500px">{{ $student->first_name . ' ' . $student->last_name }}</td>
					<td width="10px">
						<form action="{{ URL::to('/admin/administration/manage-groups/remove-student') }}" method="post">
							<input type="hidden" name="_method" value="delete">
							<input type="hidden" name="userId" value="{{ $student->id }}">
							<input type="hidden" name="groupId" value="{{ $g->id }}">
							<input type="hidden" name="_token" value="{{ csrf_token() }}">
							<button type="submit" id="delst"><i class="fam-cross"></i></button>
						</form>
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
@endforeach

@stop