@extends('admin.administration')

@section('content')
<style>
	table {
		width: 98% !important;
		margin: 0 auto !important;
	}
	.pagination {
		margin: 10px 15px;
	}
	#excel {
	    border: none;
	    width: 70px;
	    height: 38px;
	    border-radius: 3px;
	    margin: 10px 15px;
	    background: #415F2A;
	    color: #fff;
	}

	#delst {
		border: none;
		background: none;
	}

	#modal {
		width: 600px;
		display: none;
	    margin: 10px 40%;
	    border-radius: 10px;
	    z-index: 99999;
	}
</style>
	<div class="wrapper">
		<h5 class="widget-name"><br>
			<i class="icon-th"></i>Groups
		</h5>
		<div class="depth"><a href="{{ URL::to('/admin/administration/manage-groups/add-group') }}" title=""><i class="icon-plus"></i></a></div>Add New Group
		<div class="search">
			Search groups: <input type="text" id="searchbox">
		</div>
	</div><br>
	
	<div class="table-overflow">
		<table class="table table-striped table-bordered">
			<thead>
				<tr>
					<th>Name</th>
					<th>Begin date</th>
					<th>End date</th>
					<th>Tutor</th>
					<th>Course</th>
					<th>Location</th>
					<th></th>
					<th></th>
				</tr>
			</thead>
			<tbody id="fbody">
			@foreach($groups as $group)
				<tr>
					<td><a href="{{ URL::to('/admin/administration/manage-groups/details/') . '/' . $group->id }}">{{ $group->name }}</a></td>
					<td>{{ $group->begin_date }}</td>
					<td>{{ $group->end_date }}</td>
					<td>{{ $group->tutors->first_name . ' ' . $group->tutors->last_name }}</td>
					<td>{{ $group->courses->name }}</td>
					<td>{{ $group->schools->name }}</td>
					<td><div class="btn btn-primary" onclick="addStudent({{$group->id}})">Add students</div></td>
					<td>
						<form action="{{ URL::to('/') . '/admin/administration/delete-group/' . $group->id }}" method="post">
							<input type="hidden" name="_method" value="delete">
							<input type="hidden" name="_token" value="{{ csrf_token() }}">
							<button type="submit" id="delst"><i class="fam-cross"></i></button>
						</form>
					</td>
				</tr>
			@endforeach
			</tbody>
		</table>
	</div>
	<div id="modal">
		
	</div>
<script>
$("#searchbox").keyup(function () {
	//split the current value of searchInput
	var data = this.value.split(" ");
	//create a jquery object of the rows
	var jo = $("#fbody").find("tr");
	if (this.value == "") {
	    jo.show();
	    return;
	}
	//hide all the rows
	jo.hide();

	//Recusively filter the jquery object to get results.
	jo.filter(function (i, v) {
	    var $t = $(this);
	    for (var d = 0; d < data.length; ++d) {
	        if ($t.is(":contains('" + data[d] + "')")) {
	            return true;
	        }
	    }
	    return false;
	})
	//show the rows that match.
	.show();
}).focus(function () {
	this.value = "";
	$(this).css({
	    "color": "black"
	});
	$(this).unbind('focus');
}).css({
	"color": "#C0C0C0"
});
	
	/**
	 * Add student to group
	 * 
	 */
	function addStudent(groupId) 
	{
		$.post("{{ URL::to('/admin/administration/manage-groups/addStudent') }}", {"_token" : $('input[name=_token]').val(), "groupId": groupId }, function(data)
		{
			$('#modal').html(data).fadeIn();
		})
	}
</script>
@stop