@extends('admin.administration')

@section('content')
<style>
	.addgroup {
		width: 600px;
		margin: 50px 50px;
	}

	.addgroup form {
		margin: 0 auto;
	}

	#addbutton {
	    border: none;
	    width: 90px;
	    height: 38px;
	    border-radius: 3px;
	    background: #415F2A;
	    color: #fff;
	}

</style>
	<div class="addgroup">
		<h3>Add new group</h3>

		<form action="{{ URL::to('/') . '/admin/administration/add-group' }}" method="post">
			
			<label for="name">Group name</label>
			<input type="text" name="name" value="{{ $group->name }}" placeholder="Group name"><br><br>

			<label for="begin_date">Begin date</label>
			<input type="date" name="begin_date" value="{{ $group->begin_date }}" placeholder="Begin date"><br><br>

			<label for="end_date">End date</label>
			<input type="date" name="end_date" value="{{ $group->end_date }}" placeholder="End date"><br><br>

			<label for="tutor_id">Select tutor</label>
			<select name="tutor_id" id="">
				@foreach($tutors as $tutor)
					<option value="{{ $tutor->id }}">{{ $tutor->first_name . ' ' . $tutor->last_name }}</option>
				@endforeach
			</select><br><br>

			<label for="course_id">Select course</label>
			<select name="course_id" id="">
				@foreach($courses as $course)
					<option value="{{ $course->id }}">{{ $course->name }}</option>
				@endforeach
			</select><br><br>

			<label for="school_id">Select location</label>
			<select name="school_id" id="">
				@foreach($schools as $school)
					<option value="{{ $school->id }}">{{ $school->name }}</option>
				@endforeach
			</select><br><br>

			<input type="hidden" name="_token" value="{{ csrf_token() }}">

			<input type="submit" id="addbutton" name="submit" value="Add Group">

		</form>
	</div>
@stop