@extends('master')

@section('content')
<section>
<div class="new_row">
<div class="column-15 push-left-4 top_space_tutors">
    <div class="large_top_icon_tutors">
        <div class="large_top_text noicon_test_title">SHSAT</div>

    </div>
</div>
<div class="new_row row-fixed">
    <div class="column-20">
        <img src="{{ URL::asset('images/girl2.jpg') }}" alt="">
    </div>
</div>

<div class="push_underlayer1">  
    <div class="new_row zInd">
        <div id="mid_text" class="column-12 push-left-4">
            <p>The Specialized High School Admissions Test, or SHSAT, is used for admissions to the competitive specialized high schools in New York City, including Stuyvesant, Bronx High School of Science, and Brooklyn Technical High School. It is administered to eighth and ninth grade students once a year, in late October. In one of our more popular programs, The Ivy Key offers strategies and test-taking methods to master the SHSAT's rigorous scrambled paragraph questions, logical reasoning, reading comprehension, and math sections. Students learn the Ivy Key's patented methods for answering questions, proper test time management and strategies to maximize one’s score. The Ivy Key provides adept, experienced and friendly Ivy League educated instructors to not only teach students the core content of the SHSAT but also create the proper path to a great academic career. All SHSAT instruction is delivered in a comprehensive format with a personal touch, and backed by the Ivy Key guarantee.</p>
            <ul class="outInfo">
                <li><a href="#">Test dates</a></li>
                <li><a href="#">Test structure</a></li>
                <li><a href="#">Test registration</a></li>
            </ul>
        </div>
    </div>
    <div class="rowInst rowIndividual-inst">
            <div class="halfLeft ind68">
                <div class="bgTxt">
                    <h2>Individual instruction</h2>
                    <button id="indins">Schedule today</button>
                    
                </div>
                <div class="popUp">
                        <form action="" method="POST">
                            <div class="topFrm">
                                <label for="student_name">Student name</label><br>
                                <input type="text" name="student_name"><br>

                                <label for="parent_name">Parent name</label><br>
                                <input type="text" name="parent_name"><br>

                                <label for="address">Home address</label><br>
                                <input type="text" name="address"><br>

                                <label for="phone_number">Contact number</label><br>
                                <input type="text" name="phone_number"><br>

                                <label for="email">E-Mail address</label><br>
                                <input type="email" name="email"><br>
                            </div>

                            <div class="rFrm">
                                

                                <label for="tut-hours" class="tut-down">
                                <select name="tut-hours" id="">
                                    <option value="" disabled selected>Number of tutoring hours</option>
                                    <option>1-5 Hours</option>
                                    <option>6-10 Hours</option>
                                    <option>10-20 Hours</option>
                                    <option>20+ Hours</option>
                                </select>
                                </label>
                                 <br>
                                <label for="tut-topic" class="tut-down">
                                <select name="tut-topic" id="">
                                    <option value="" disabled selected>Desired tutoring day</option>
                                    <option value="monday">Monday</option>
                                    <option value="tuesday">Tuesday</option>
                                    <option value="wednesday">Wednesday</option>
                                    <option value="thursday">Thursday</option>
                                    <option value="friday">Friday</option>
                                    <option value="saturday">Saturday</option>
                                    <option value="sunday">Sunday</option>
                                </select>
                                </label> 
                                <br>
                                <label for="tut-daytime" class="tut-down">
                                <select name="tut-daytime" id="">
                                    <option value="" disabled selected>Desired tutoring time</option>
                                    <option value="12:00 AM">12:00 AM</option>
                                    <option value="1:00 AM">1:00 AM</option>
                                    <option value="2:00 AM">2:00 AM</option>
                                    <option value="3:00 AM">3:00 AM</option>
                                    <option value="4:00 AM">4:00 AM</option>
                                    <option value="5:00 AM">5:00 AM</option>
                                    <option value="6:00 AM">6:00 AM</option>
                                    <option value="7:00 AM">7:00 AM</option>
                                    <option value="8:00 AM">8:00 AM</option>
                                    <option value="9:00 AM">9:00 AM</option>
                                    <option value="10:00 AM">10:00 AM</option>
                                    <option value="11:00 AM">11:00 AM</option>
                                    <option value="12:00 AM">12:00 AM</option>
                                    <option value="1:00 PM">1:00 PM</option>
                                    <option value="2:00 PM">2:00 PM</option>
                                    <option value="3:00 PM">3:00 PM</option>
                                    <option value="4:00 PM">4:00 PM</option>
                                    <option value="5:00 PM">5:00 PM</option>
                                    <option value="6:00 PM">6:00 PM</option>
                                    <option value="7:00 PM">7:00 PM</option>
                                    <option value="8:00 PM">8:00 PM</option>
                                    <option value="9:00 PM">9:00 PM</option>
                                    <option value="10:00 PM">10:00 PM</option>
                                    <option value="11:00 PM">11:00 PM</option>
                                </select>
                                </label>
                                <br>

                                <label for="tutor" class="tut-down">
                                <select name="tutor" id="">
                                    <option value="" disabled selected>Desired tutor</option>
                                    @foreach($tutors as $tutor)
                                    <option value="{{ $tutor->id }}">{{ $tutor->first_name . ' ' . $tutor->last_name }}</option>
                                    @endforeach
                                </select>
                                </label>
                                <br>
                                <label for="comments">Additional comments</label><br>
                                <textarea name="comments" id="" cols="40" rows="7"></textarea>

                                <div class="btnGr">
                                    <div class="submitBtn"><input type="submit" id="submit" name="submit" value="Submit"></div>
                                </div>

                            </div>
                        </form>
                                <div class="cancelBtn"><input type="submit" id="cancel" name="cancel" value="Cancel"></div>
                    </div>
            </div>
            <div class="halfRight">

                <ul>
                <li><h3>Features</h3></li>
                <li>Ivy Key instructors work with a student in one-on-one setting.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client’s home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports. </li>
                <li>Ivy Key instructors skillfully guide students through all sections of the SHSAT with personalized support designed to meet students’ needs and score goals.</li>
                </ul>
            </div>    
    </div>
    <div class="rowInst rowClassroom-inst">
            <div class="halfRight halfHide class68">
            <div class="bgTxt">
            <h2>Classroom Instruction</h2>
            <a href="{{ URL::to('/programs/SHSAT') }}">Register</a>
            </div>
            </div>
            <div class="halfLeft">
            <ul>
                <li><h3>Features</h3></li>
                <li>A robust 32-hour SHSAT course to teach students the core content of all sections covered on the SHSAT.</li>
                <li>Provided 3 full-length mock SHSAT exams with comprehensive evaluations and score reports to measure improvement. </li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments</li>
                <li>Class sizes range from 15 to 20 students.</li>
                <li>Classes are held at Ivy Key learning centers, partnership schools and online.</li>
            </ul>
            </div>
            <div class="halfRight halfShow class68">
             <div class="bgTxt">   
            <h2>Classroom Instruction</h2>
            <a href="{{ URL::to('/programs/SHSAT') }}">Register</a>
            </div>
             </div>
    </div>
    <div class="rowInst rowOnline-inst">
            <div class="halfLeft halfShow online68">
            <div class="bgTxt">
            <h2>Online instruction</h2>
            <a href="#">Schedule today</a>
            </div>
        </div>
            <div class="halfRight">
                <ul>
                <li><h3>Features</h3></li>
                <li>Ivy League instructors conduct one-on-one tutoring sessions with students via the internet. </li>
                <li>Online tutoring sessions can administered via computer or mobile device.</li>
                <li>Online tutoring is recommended for students who have busy extracurricular schedules or students who are prone to travel.</li>
                <li>An experienced Ivy Key instructor will skillfully guide students through different sections of the SHSAT with personalized support designed to meet students’ needs and score goals. </li>
            </ul>
            </div>        
    </div>

<div class="rowInst rowGroup-inst">
            <div class="halfLeft halfHide group68">
            <div class="bgTxt">
            <h2>Small group instruction</h2>
            <a href="#">Schedule today</a>
            </div>
        </div>
            <div class="halfRight">
                <ul>
                <li><h3>Features</h3></li>
                <li>Ivy Key instructors work with students in a small group setting.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client's home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports. </li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments.</li>
                <li>Class sizes range from 2 to 5 students.</li>
            </ul>
            </div>    
            <div class="halfRight halfShow group68">
             <div class="bgTxt">   
                <h2>Small Group Instruction</h2>
                <a href="#">Register</a>
            </div>    
                
                
            
    </div>
	@include('partials.findtutorprogram')
<script>
	$('.row-fixed-content').addClass('tutors-top-content');

    $('#indins').on('click', function(){
        $('.popUp').animate({'top': '0px'});
    });

    $('#cancel').on('click', function(){
        $('.popUp').animate({'top': '-500px'});
    })
</script>
@stop