@extends('master')

@section('content')
<section>
<div class="new_row">
<div class="column-15 push-left-4 top_space_tutors">
    <div class="large_top_icon_tutors">
        <div class="large_top_text noicon_test_title">SAT</div>

    </div>
</div>
<div class="new_row row-fixed">
    <div class="column-20">
        <img src="{{ URL::asset('images/girl2.jpg') }}" alt="">
    </div>
</div>

<div class="push_underlayer1">  
    <div class="new_row">
        <div id="mid_text" class="column-12 push-left-4">
            <p>The SAT is a standardized test used in determining admissions to U.S. colleges. The current SAT consists of 3 sections: Math, Reading, and Writing, as well as a written essay scored within the writing section. Students learn the Ivy Key's patented methods for answering questions, proper test time management and strategies to maximize one’s score. The Ivy Key provides adept, experienced and friendly Ivy League educated instructors to not only teach students the core content of the SAT but also create the proper path to a great college career. All SAT instruction is delivered in a comprehensive format with a personal touch, and backed by the Ivy Key guarantee.</p>
            <ul class="outInfo">
                <li><a href="#">Test dates</a></li>
                <li><a href="#">Test structure</a></li>
                <li><a href="#">Test registration</a></li>
            </ul>
        </div>
    </div>
    
    <div class="rowInst rowIndividual-inst">
            <div class="halfLeft hsInd">
                <div class="bgTxt">
                <h2>Individual instruction</h2>
                <a href="#">Schedule today</a>
                </div>
            </div>
            <div class="halfRight">
                <ul>
                <li>Ivy Key instructors work with a student in one-on-one settings.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client's home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports.</li>
                <li>Ivy Key instructors skillfully guide students through all sections of the SAT with personalized support designed to meet student's needs and score goals.</li>
            </ul>
            </div>    
    </div>
    <div class="rowInst rowClassroom-inst">
            <div class="halfRight halfHide hsClass">
            <div class="bgTxt">
            <h2>Classroom instruction</h2>
            <a href="{{ URL::to('/programs/SAT') }}">Register</a>
            </div>
            </div>
            <div class="halfLeft">
            <ul>
                <li>A robust 30-hour SAT course to teach students the core content of the English, Math and Reading sections.</li>
                <li>Provided 3 full-length mock SAT exams with comprehensive evaluations and score reports to measure improvement.</li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments.</li>
                <li>Class sizes range from 15 to 20 students.</li>
                <li>Classes are held at Ivy Key learning centers, partnership schools and online.</li>
            </ul>
            </div>
            <div class="halfRight halfShow hsClass">
             <div class="bgTxt">   
            <h2>Classroom instruction</h2>
            <a href="{{ URL::to('/programs/SAT') }}">Register</a>
            </div>
             </div>
    </div>
    <div class="rowInst rowOnline-inst">
            <div class="halfLeft hsOnline">
            <div class="bgTxt">
            <h2>Online instruction</h2>
            <a href="#">Schedule today</a>
            </div>
        </div>
            <div class="halfRight">
                <ul>
                <li>Ivy League instructors conduct one-on-one tutoring sessions with students via internet.</li>
                <li>Online tutoring sessions can administered via computer or mobile device.</li>
                <li>Online tutoring is recommended for students who have busy extracurricular schedules or students who are prone to travel.</li>
                <li>An experienced Ivy Key instructor will skillfully guide students through different sections of the SAT with personalized support designed to meet student's needs and score goals.</li>
            </ul>
            </div>        
    </div>
    <div class="rowInst rowGroup-inst">
            <div class="halfRight halfHide hsGroup">
            <div class="bgTxt">
            <h2>Small group instruction</h2>
            <a href="#">Schedule today</a>
             </div>
            </div>
            <div class="halfLeft">
            <ul>
                <li>Ivy Key instructors work with students in a small group setting.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client's home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports.</li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments.</li>
                <li>Class sizes range from 2 to 5 students.</li>
            </ul>
            </div>
            <div class="halfRight halfShow hsGroup">
                <div class="bgTxt">
            <h2>Small group instruction</h2>
            <a href="#">Schedule today</a>
            </div>
              </div>
       
    </div>
	@include('partials.findtutorprogram')
<script>
	$('.row-fixed-content').addClass('tutors-top-content');
</script>
@stop