<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SAT page</title>
     <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="css/sn-grid.css">
    <link rel="stylesheet" href="css/style.css">
</head>
<body>


<section>
<div class="new_row">
<div class="column-15 push-left-4 top_space_tutors">
    <div class="large_top_icon_tutors">
        <div class="large_top_text noicon_test_title">SAT</div>

    </div>
</div>
<div class="new_row row-fixed">
    <div class="column-20">
        <?php // echo Html::image('assets/images/girl2.jpg'); ?>
    </div>
</div>

<div class="push_underlayer1">  
    <div class="new_row">
        <div id="mid_text" class="column-12 push-left-4">
            <p>The SAT is a standardized test used in determining admissions to U.S. colleges. The current SAT consists of 3 sections: Math, Reading, and Writing, as well as a written essay scored within the writing section. Students learn the Ivy Key's patented methods for answering questions, proper test time management and strategies to maximize one’s score. The Ivy Key provides adept, experienced and friendly Ivy League educated instructors to not only teach students the core content of the SAT but also create the proper path to a great college career. All SAT instruction is delivered in a comprehensive format with a personal touch, and backed by the Ivy Key guarantee.</p>
            <ul class="outInfo">
                <li><a href="#">Test dates</a></li>
                <li><a href="#">Test structure</a></li>
                <li><a href="#">Test registration</a></li>
            </ul>
        </div>
    </div>
    
    <div class="rowInst rowIndividual-inst">
            <div class="halfLeft hsInd">
                <div class="bgTxt">
                <h2>Individual instruction</h2>
                <a href="#">Schedule today</a>
                </div>
            </div>
            <div class="halfRight">
                <ul>
                <li>Ivy Key instructors work with a student in one-on-one settings.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client's home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports.</li>
                <li>Ivy Key instructors skillfully guide students through all sections of the SAT with personalized support designed to meet student's needs and score goals.</li>
            </ul>
            </div>    
    </div>
    <div class="rowInst rowClassroom-inst">
            <div class="halfRight halfHide hsClass">
            <div class="bgTxt">
            <h2>Classroom instruction</h2>
            <a href="#">Register</a>
            </div>
            </div>
            <div class="halfLeft">
            <ul>
                <li>A robust 30-hour SAT course to teach students the core content of the English, Math and Reading sections.</li>
                <li>Provided 3 full-length mock SAT exams with comprehensive evaluations and score reports to measure improvement.</li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments.</li>
                <li>Class sizes range from 15 to 20 students.</li>
                <li>Classes are held at Ivy Key learning centers, partnership schools and online.</li>
            </ul>
            </div>
            <div class="halfRight halfShow hsClass">
             <div class="bgTxt">   
            <h2>Classroom instruction</h2>
            <a href="#">Register</a>
            </div>
             </div>
    </div>
    <div class="rowInst rowOnline-inst">
            <div class="halfLeft hsOnline">
            <div class="bgTxt">
            <h2>Online instruction</h2>
            <a href="#">Schedule today</a>
            </div>
        </div>
            <div class="halfRight">
                <ul>
                <li>Ivy League instructors conduct one-on-one tutoring sessions with students via internet.</li>
                <li>Online tutoring sessions can administered via computer or mobile device.</li>
                <li>Online tutoring is recommended for students who have busy extracurricular schedules or students who are prone to travel.</li>
                <li>An experienced Ivy Key instructor will skillfully guide students through different sections of the SAT with personalized support designed to meet student's needs and score goals.</li>
            </ul>
            </div>        
    </div>
    <div class="rowInst rowGroup-inst">
            <div class="halfRight halfHide hsGroup">
            <div class="bgTxt">
            <h2>Small group instruction</h2>
            <a href="#">Schedule today</a>
             </div>
            </div>
            <div class="halfLeft">
            <ul>
                <li>Ivy Key instructors work with students in a small group setting.</li>
                <li>Flexible scheduling and tutoring sessions can be held at the client's home, Ivy Key learning center or location of choice.</li>
                <li>Full-length mock exams with comprehensive evaluations and score reports.</li>
                <li>Comprehensive tutoring strategies coupled with in-class exercises and weekly homework assignments.</li>
                <li>Class sizes range from 2 to 5 students.</li>
            </ul>
            </div>
            <div class="halfRight halfShow hsGroup">
                <div class="bgTxt">
            <h2>Small group instruction</h2>
            <a href="#">Schedule today</a>
            </div>
              </div>
       
    </div>
    
    <!--<div class="new_row">
        <div class="column-20 tests-structure-box">
            <div class="new_row">
                <div class="column-14 push-left-3 empty-1-lr">
                    <div class="new_row">
                        <div class="column-10 struct" style="padding-right: 2.08vw;padding-top: 1.04vw;">
                            <?php //echo Html::image('assets/images/test002.jpg'); ?>
                        </div>
                        <div class="column-10">
                            <div class="struct-title">Our Test Strategy</div>
                            <div class="struct-content">The Ivy Key recommends you take the ACT once at the end of your junior year, then again at the beginning of your senior year. Preparation for the ACT should start 5 months prior to the exam date. The Ivy Key offers a robust 10-class ACT course to teach students the core content of the English, math, reading, and science sections of the current ACT as well as several full length mock exams to measure improvement on a monthly basis. Our English sections cover the rules of standard written English, including grammar and usage as well as rhetorical skills. For the math section, we reinforce aptitude in high school math topics including algebra, geometry and basic trigonometry. For the reading section, we reinforce reading comprehension skills. For the science section we sharpen the interpretation, analysis, evaluation, reasoning, and problem-solving skills required in the natural sciences. Our strategy is to teach and reinforce the material, and regularly practice by simulating the real-life test-taking situation. The Ivy Key can also provide you with a private tutor to focus on the student's weaknesses and develop their strengths. </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    <div class="new_row title1">
        <div class="column-12 push-left-4 text-left">
            <p>Test Format</p>
        </div>
    </div>
    <div class="new_row">
        <div class="column-12 push-left-4">
            <table class="table-structure">
                <tr><th class="col1">Section</th><th class="col2">Length</th><th class="col3">Question Types</th></tr>

                
                <tr>
                <td>English</td>
                <td>45 Minutes</td>
                <td>40 Usage/Mechanics Questions<br/>35 Rhetorical Skills Questions</td>
                </tr>
                <tr>
                <td>Mathematics</td>
                <td>60 minutes</td>
                <td>14 Arithmetic Questions<br/>10 Elementary Algebra Questions<br/>9 Intermediate Algebra Questions<br/>9 Coordinate Geometry Questions<br/>14 Plane Geometry Questions<br/>4 Trigonometry Questions</td>
                </tr>
                <tr>
                <td>Reading</td>
                <td>35 Minutes</td>
                <td>10 Social Studies Questions<br/>10 Natural Sciences Questions<br/>10 Prose Fiction Questions<br/>10 humanities Questions</td>
                </tr>
                <tr>
                <td>Science</td>
                <td>35 Minutes</td>
                <td>15 Data Representation Questions<br/>18 Research Summary Questions<br/>7 Conflicting Viewpoint Questions</td>
                </tr>
                <tr>
                <td>Writing Test (optional)</td>
                <td>30 Minutes</td>
                <td>You write in response to a question about your position on an issue</td>
                </tr>
            </table>
        </div>
    </div>
    
    
    <div class="new_row title1">
        <div class="column-12 push-left-4 text-left">
            <p>Test Calendar</p>
        </div>
    </div>
    <div class="new_row">
        <div class="column-12 push-left-4">
            <table class="table-structure">
                <tr><th class="col1d">Test Date</th><th class="col3d">Registration Deadline</th><th class="col4d">Late Registration Deadline</th></tr>

                    <tr>
                        <td>September 13, 2014</td>
                        <td>August 8, 2014</td>
                        <td>August 9–22, 2014</td>
                    </tr>
                    <tr>
                        <td>October 25, 2014</td>
                        <td>September 19, 2014</td>
                        <td>September 20–October 3, 2014</td>
                    </tr>
                    <tr>
                        <td>December 13, 2014</td>
                        <td>November 7, 2014</td>
                        <td>November 8–21, 2014</td>
                    </tr>
                    <tr>
                        <td>February 7, 2015 *</td>
                        <td>January 9, 2015</td>
                        <td>January 10–16, 2015</td>
                    </tr>
                    <tr>
                        <td>April 18, 2015</td>
                        <td>March 13, 2015</td>
                        <td>March 14–27, 2015</td>
                    </tr>
                    <tr>
                        <td>June 13, 2015</td>
                        <td>May 8, 2015</td>
                        <td>May 9–22, 2015</td>
                    </tr>
                    
                
            </table>
            * No test centers are scheduled in New York for the February test date.
        </div>
    </div>-->
   
    
    </div>
    <!-- @include('partials.findtutorprogram') -->
    <style>
.fsp-left {
    float: left;
    margin-left: 16vw;
}
.fsp-right {
    float: right;
    margin-right: 16vw;
}
</style>
<div class="new_row">
    <div class="column-20 find-school">  
        <div class="find-schoolprogram-box fsp-left">
            <div class="fsb-sch-prg">
                <p>Find a tutor</p>
                <p>Let's find a tutor for you. The Ivy Key's highly qualified tutors are located all over New York City. We can match you with a tutor that conveniently suits you best based on subject and location. All of our services and programs are instructed by our team of Ivy League tutors.</p>
                <form name="tutors-search-form" action="/search/tutors_by_subject" method="post">
                    <input type="text" name="subject" value="">
                    <input type="submit" name="submit" value="Search">
                </form>
            </div>
        </div>
        <div class="find-schoolprogram-box fsp-right">
            <div class="fsb-sch-prg">
                <p>Find a program</p>
                <p>Let's find a program near you. The Ivy Key hosts programs at many locations all over New York City. We can find the program that conveniently suits you best based on subject and location. All of our services and programs are instructed by our team of Ivy League tutors.</p>
                <form name="tutors-search-form" action="/search/find_program" method="post">
                    <input type="text" name="search" value="">
                    <input type="submit" name="submit" value="Search">
                </form>
            </div>
        </div>
    </div>
</div>
</section>
    
</body>
</html>