<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateProgramsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('programs', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->date('startDate');
            $table->string('forExam');
            $table->string('meetsOn');
            $table->integer('price');
            $table->string('firstName');
            $table->string('lastName');
            $table->string('photoURL');
            $table->string('dayOfWeek');
            $table->string('type');
            $table->string('programLocation');
            $table->string('schoolName');
            $table->string('schoolAddress');
            $table->string('schoolZip');
            $table->string('schoolCountry');
            $table->tinyInteger('active');
            $table->string('paymentLink');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('programs');
    }
}
