<?php

namespace App\Validators;

class CreateUserValidator extends Validator {

	public static $rules = [

		'username'      => 'required|alpha_num|max:255',
		'first_name'    => 'required|alpha|max:255',
		'last_name'     => 'required|alpha|max:255',
		'email'         => 'required|min:4|max:255|email',
		'password'      => 'required|min:6|confirmed',
		'password_confirmation'  => 'required|min:6',
		'parent_email'  => 'required|min:4|max:255|email',
		'grade_id'         => 'required|numeric',
		'school_id'        => 'required|numeric',
		'course_id'        => 'required|numeric',
		'address'       => 'required|max:255',
		'city'          => 'required|max:255',
		'zip'           => 'required|numeric',
		'state'         => 'required|max:255',
		'country'       => 'required|max:255',
		'home_phone'   => 'required|min:8|max:20',
		'parent_phone' => 'required|min:8|max:20',

	];

	public static $messages = array();

}