<?php

namespace App;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Foundation\Auth\Access\Authorizable;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;

class User extends Model implements AuthenticatableContract,
                                    AuthorizableContract,
                                    CanResetPasswordContract
{
    use Authenticatable, Authorizable, CanResetPassword;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'users';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['email', 'password', 'first_name', 'last_name', 'parent_email', 'address'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['password', 'remember_token'];

    /**
     * @return Course
     */
    public function course()
    {
        return $this->hasOne('Course');
    }

    /**
     * @return Grade
     */
    public function grade()
    {
        return $this->hasOne('Grade');
    }

    /**
     * @return School
     */
    public function schools()
    {
        return $this->belongsTo('App\School');
    }

    /**
     * @return program_user pivot table
     */
    public function programs()
    {
        return $this->belongsToMany('App\Program');
    }

    public function notes()
    {
        return $this->hasMany('App\Notes');
    }

    public function groups()
    {
        return $this->belongsToMany('App\Group', 'group_user');
    }
}
