<?php

namespace App\Repositories;

use App\Interfaces\UserRepositoryInterface;
use App\User;

class UserRepository implements UserRepositoryInterface {

	/**
	 * @var User
	 */
	private $user;

	public function __construct(User $user)
	{
		$this->user = $user;
	}

	/**
	 * Get All Users
	 * 
	 * @return mixed
	 */
	public function getAllUsers()
	{
		return $this->user->all();
	}

	/**
	 * Get Single User
	 *
	 * @param  $id
	 * @return mixed
	 */
	public function getUser($id)
	{
		return $this->user->findOrFail($id);
	}

	/**
	 * Create User
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function createUser(array $data)
	{
		$user = $this->fillUserObject($this->user, $data);
		$user->save();

		return $user;
	}

	/**
	 * Edit User
	 *
	 * @param  $id
	 * @param  array $data
	 * @return mixed
	 */
	public function editUser($id, array $data)
	{
		$user = $this->user->find($id);

		if(! is_null($user))
		{
			$user = $this->fillUserObject($user, $data);
			$user->save();
			
			return $user;
		}
		
		return $this->respondInternalError('Error creating user.');

	}

	/**
	 * Delete User
	 *
	 * @param  $id
	 * @return mixed
	 */
	public function deleteUser($id)
	{
		$user = $this->user->find($id);

		if($user->delete())
		{
			return 'User deleted.';
		}
	}

	/**
	 * Create User Object
	 * 
	 * @param  Object $object
	 * @param  array $data
	 * @return mixed
	 */
	public function fillUserObject($object, $data)
	{
		if(isset($data['username']))
		{
			$object->username = $data['username'];
		}

		if(isset($data['first_name']))
		{
			$object->first_name = $data['first_name'];
		}

		if(isset($data['last_name']))
		{
			$object->last_name = $data['last_name'];
		}

		if(isset($data['email']))
		{
			$object->email = $data['email'];
		}

		if(isset($data['password']))
		{
			$object->password = $data['password'];
		}

		if(isset($data['grade_id']))
		{
			$object->grade_id = $data['grade_id'];
		}

		if(isset($data['school_id']))
		{
			$object->school_id = $data['school_id'];
		}

		if(isset($data['course_id']))
		{
			$object->course_id = $data['course_id'];
		}

		if(isset($data['address']))
		{
			$object->address = $data['address'];
		}

		if(isset($data['city']))
		{
			$object->city = $data['city'];
		}

		if(isset($data['zip']))
		{
			$object->zip = $data['zip'];
		}

		if(isset($data['state']))
		{
			$object->state = $data['state'];
		}

		if(isset($data['country']))
		{
			$object->country = $data['country'];
		}

		if(isset($data['home_phone']))
		{
			$object->home_phone = $data['home_phone'];
		}

		if(isset($data['parent_phone']))
		{
			$object->parent_phone = $data['parent_phone'];
		}

		if(isset($data['parent_email']))
		{
			$object->parent_email = $data['parent_email'];
		}

		if($object->code !== 'confirmed')
		{
			$object->code = str_random();
		}

		return $object;
	}

}