<?php 

namespace App\Repositories;

use App\Interfaces\TutorRepositoryInterface;
use App\Tutor;

class TutorRepository implements TutorRepositoryInterface {

	/**
	 * @var Tutor
	 */
	private $tutor;

	public function __construct(Tutor $tutor)
	{
		$this->tutor = $tutor;
	}

	/**
	 * Get all tutors
	 * 
	 * @return mixed
	 */
	public function getTutors()
	{
		$tutors = $this->tutor->all();

		return $tutors;
	}

	/**
	 * Create new tutor
	 * 
	 * @return mixed
	 */
	public function postTutor(array $data)
	{
		$tutor = $this->fillTutorObject($this->tutor, $data);
		$tutor->save();

		return $tutor;
	}

	/**
	 * Edit tutor
	 * @param  int $id 
	 * @return mixed
	 */
	public function editTutor($id)
	{
	    $tutor = $this->tutor->find($id);

	    return $tutor;
	}

	/**
	 * Update tutor
	 *
	 * @param  int $id
	 * @param array $data
	 * @return mixed
	 */
	public function updateTutor($id, array $data)
	{
		$tutor = $this->tutor->find($id);
		dd($tutor);
		if(! is_null($tutor))
		{
			$tutor = $this->fillTutorObject($tutor, $data);
			$tutor->save();

			return $tutor;
		}

		return false;
	}

	/**
	 * Delete tutor
	 * 
	 * @param  int $id
	 * @return [type]
	 */
	public function deleteTutor($id)
	{
		$tutor = $this->tutor->find($id);

		if($tutor->delete())
		{
			return true;
		}

		return false;
	}

	/**
	 * @param  obj $object
	 * @param  array  $data
	 * @return obj
	 */
	public function fillTutorObject($object, array $data)
	{
		if(isset($data['username']))
		{
			$object->username = $data['username'];
		}

		if(isset($data['password']))
		{
			$object->password = $data['password'];
		}

		if(isset($data['first_name']))
		{
			$object->first_name = $data['first_name'];
		}

		if(isset($data['last_name']))
		{
			$object->last_name = $data['last_name'];
		}

		if(isset($data['email']))
		{
			$object->email = $data['email'];
		}

		if(isset($data['position']))
		{
			$object->position = $data['position'];
		}

		if(isset($data['location']))
		{
			$object->location = $data['location'];
		}

		if(isset($data['university']))
		{
			$object->university = $data['university'];
		}

		if(isset($data['subject']))
		{
			$object->subject = $data['subject'];
		}

		if(isset($data['about']))
		{
			$object->about = $data['about'];
		}

		if(isset($data['photoURL']))
		{
			$object->photoURL = $data['photoURL']->getClientOriginalName();
		}

		return $object;
	}

	/**
	 * [toggleActiveTutor]
	 * @param  int $posted
	 * @return mixed
	 */
	public function toggleActiveTutor($posted)
	{
	    $toggle_active = $this->tutor->find($posted);
	    if($toggle_active->active){
	      $toggle_active->active = 0;
	      $return = 0;
	    } else {
	      $toggle_active->active = 1;
	      $return = 1;
	    }	    
	    $toggle_active->save();

	    return $toggle_active;
	}
}