<?php 

namespace App\Repositories;

use App\Testimonial;
use App\Interfaces\TestimonialRepositoryInterface;

class TestimonialRepository implements TestimonialRepositoryInterface {

	/**
	 * @var Testimonial
	 */
	private $testimonial;

	public function __construct(Testimonial $testimonial)
	{
		$this->testimonial = $testimonial;
	}

	/**
	 * Get testimonials
	 * 
	 * @return mixed
	 */
	public function getTestimonials()
	{
		$testimonials = $this->testimonial->all();

		return $testimonials;
	}

	/**
	 * Get testimonial by id
	 * 
	 * @param  int $id
	 * @return mixed
	 */
	public function getTestimonialById($id)
	{
		return $this->testimonial->find($id);
	}

	/**
	 * Create testimonial
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function postTestimonial(array $data)
	{
		$testimonials = $this->fillTestimonialObject($this->testimonial, $data);

		if($testimonials->save())
		{
			return $testimonials;
		}

		return false;
	}

	/**
	 * Update testimonial
	 *
	 * @param  int $id
	 * @param  array $data
	 * @return mixed
	 */
	public function updateTestimonial($id, array $data)
	{
		$testimonial = $this->testimonial->find($id);

		if(! is_null($testimonial))
		{
			$testimonial = $this->fillTestimonialObject($testimonial, $data);
			$testimonial->save();

			return $testimonial;
		}

		return false;
	}

	/**
	 * Delete testimonial
	 * 
	 * @param  int $id
	 * @return mixed
	 */
	public function deleteTestimonial($id)
	{
		$testimonail = $this->testimonial->find($id);

		if($testimonial->delete())
		{
			return true;
		}

		return false;
	}

	/**
	 * Fill Testimonial Object
	 * 
	 * @param  obj $object
	 * @param  array  $data
	 * @return obj
	 */
	public function fillTestimonialObject($object, array $data)
	{
		if(isset($data['first_name']))
		{
			$object->first_name = $data['first_name'];
		}

		if(isset($data['last_name']))
		{
			$object->last_name = $data['last_name'];
		}

		if(isset($data['testimonial']))
		{
			$object->testimonial = $data['testimonial'];
		}

		if(isset($data['school']))
		{
			$object->school = $data['school'];
		}

		if(isset($data['photoURL']))
		{
			$object->photoURL = $data['photoURL'];
		}

		$object->active = 0;

		return $object;
	}

	/**
	 * [toggleActiveTestimonial description]
	 * @param  int $posted
	 * @return mixed
	 */
	public function toggleActiveTestimonial($posted)
	{
	    $toggle_active = $this->testimonial->find($posted);
	    if($toggle_active->active){
	      $toggle_active->active = 0;
	      $return = 0;
	    } else {
	      $toggle_active->active = 1;
	      $return = 1;
	    }	    
	    $toggle_active->save();

	    return $toggle_active;
	}
}