<?php 

namespace App\Repositories;

use App\School;
use App\Interfaces\SchoolRepositoryInterface;

class SchoolRepository implements SchoolRepositoryInterface {

	/**
	 * @var School
	 */
	private $school;

	public function __construct(School $school)
	{
		$this->school = $school;
	}

		/**
	 * Get schools
	 * 
	 * @return view
	 */
	public function getSchools()
	{
		$schools = $this->school->all();

		return $schools;
	}

	/**
	 * Get Primary K5 Schools
	 * 
	 * @return mixed
	 */
	public function getK5schools()
	{
	    $schools = $this->school->where('school_type_id', 1)->get();

	    return $schools;
	}

	/**
	 * Get Middle 6-8 Schools
	 * 
	 * @return mixed
	 */
	public function getMiddle68schools()
	{
	    $schools = $this->school->where('school_type_id', 2)->get();

	    return $schools;
	}

	/**
	 * Get High Schools
	 * 
	 * @return mixed
	 */
	public function getHighschools()
	{
	    $schools = $this->school->where('school_type_id', 3)->get();

	    return $schools;
	}

	/**
	 * Create school
	 *
	 * @param  array $data
	 * @return view
	 */
	public function postSchool(array $data)
	{
		$school = $this->fillSchoolObject($this->school, $data);

		if($school->save())
		{
			return $school;
		}

		return false;
	}

	public function editSchool($id)	
	{
	    $school = $this->school->find($id);

	    return $school;
	}

	/**
	 * Update school
	 *
	 * @param  int $id
	 * @param  array $data
	 * @return view
	 */
	public function updateSchool($id, array $data)
	{
		$school = $this->school->find($id);
		$school = $this->fillSchoolObject($school, $data);
		$school->save();

		return $school;
	}

	/**
	 * Delete school
	 *
	 * @param  int $id
	 * @return view
	 */
	public function deleteSchool($id)
	{
		$school = $this->school->find($id);
		dd($school);
		if($school->delete())
		{
			return true;
		}

		return false;
	}

	/**
	 * @param  obj $object
	 * @param  array  $data
	 * @return obj
	 */
	public function fillSchoolObject($object, array $data)
	{
		if(isset($data['name']))
		{
			$object->name = $data['name'];
		}

		if(isset($data['address']))
		{
			$object->address = $data['address'];
		}

		if(isset($data['zip_code']))
		{
			$object->zip_code = $data['zip_code'];
		}

		if(isset($data['county']))
		{
			$object->county = $data['county'];
		}

		if(isset($data['school_type_id']))
		{
			$object->school_type_id = $data['school_type_id'];
		}

		return $object;
	}

}