<?php

namespace App\Repositories;

use App\Program;
use App\Interfaces\ProgramRepositoryInterface;

class ProgramRepository implements ProgramRepositoryInterface {

	/**
	 * @var Program
	 */
	private $program;

	public function __construct(Program $program)
	{
		$this->program = $program;
	}


	/**
	 * Get programs
	 * 
	 * @return mixed
	 */

	public function getPrograms()
	{
		$programs = $this->program->all();

		return $programs;
	}

	/**
	 * Get single program
	 *
	 * @var  int $id
	 * @return mixed
	 */
	public function getProgram($id)
	{
		$program = $this->program->find($id);
		// dd($program);
		return $program;
	}

	/**
	 * Create program
	 * 
	 * @param  array  $data
	 * @return mixed
	 */
	public function postProgram(array $data)
	{
		$program = $this->fillProgramObject($this->program, $data);

		if($program->save())
		{
			return $program;
		}

		return false;
	}

	/**
	 * Edit program
	 * 
	 * @param  int $id
	 * @param  array  $data
	 * @return mixed
	 */
	public function editProgram($id, array $data)
	{
		$program = $this->program->find($id);
		$program = $this->fillProgramObject($program, $data);
		$program->save();

		return $program;
	}

	/**
	 * Delete program
	 * 
	 * @param  int $id
	 * @return mixed
	 */
	public function deleteProgram($id)
	{
		$program = $this->program->find($id);

		if($program->delete())
		{
			return true;
		}

		return false;
	}

	public function fillProgramObject($object, $data)
	{
		if(isset($data['name']))
		{
			$object->name = $data['name'];
		}

		if(isset($data['startDate']))
		{
			$object->startDate = $data['startDate'];
		}

		if(isset($data['forExam']))
		{
			$object->forExam = $data['forExam'];
		}

		if(isset($data['meetsOn']))
		{
			$object->meetsOn = $data['meetsOn'];
		}

		if(isset($data['name']))
		{
			$object->name = $data['name'];
		}

		if(isset($data['price']))
		{
			$object->price = $data['price'];
		}

		if(isset($data['firstName']))
		{
			$object->firstName = $data['firstName'];
		}

		if(isset($data['lastName']))
		{
			$object->firstName = $data['firstName'];
		}

		if(isset($data['firstName']))
		{
			$object->firstName = $data['firstName'];
		}

		if(isset($data['firstName']))
		{
			$object->firstName = $data['firstName'];
		}

		if(isset($data['firstName']))
		{
			$object->firstName = $data['firstName'];
		}
	}
}