<?php

namespace App\Repositories;

use App\Interfaces\PaymentRepositoryInterface;
use App\Program;
use App\User;

class PaymentRepository implements PaymentRepositoryInterface {

	/**
	 * @var Program
	 */
	private $program;

	/**
	 * @var User
	 */
	private $user;

	public function __construct(Program $program, User $user)
	{
		$this->program = $program;
		$this->user = $user;
	}

	public function postPayment()
	{
		
	}

	/**
	 * Activate user
	 * 
	 * @return mixed
	 */
	public function activateUser($code)
	{
		$user = $this->user->whereCode($code)->first();

		if($user)
		{
			$user->active = 1;
			
			if($user->code != 'confirmed')
			{
				$user->code = 'confirmed';
			}
			$user->save();

		}

		return $user;
	}


}