<?php

namespace App\Repositories;

use App\News;
use App\Interfaces\NewsRepositoryInterface;

class NewsRepository implements NewsRepositoryInterface {

	public function __construct(News $news)
	{
		$this->news = $news;
	}

	/**
	 * Get news
	 * 
	 * @return mixed
	 */
	public function getNews()
	{
		$news = $this->news->all();

		return $news;
	}

	/**
	 * Create news
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function postNews(array $data)
	{
		$news = $this->fillNewsObject($this->news, $data);

		if($news->save())
		{
			return $news;
		}

		return false;
	}

	/**
	 * Edit news
	 * 
	 * @return mixed
	 */
	public function editNews($id, array $data)
	{
		$news = $this->news->find($id);
		$news = $this->fillNewsObject($news, $data);
		$news->save();

		return $news;
	}

	/**
	 * Delete mixed
	 *
	 * @param  int $id
	 * @return view
	 */
	public function deleteNews($id)
	{
		$news = $this->news->find($id);

		if($news->delete())
		{
			return true;
		}

		return false;
	}

	/**
	 * @param  obj $object
	 * @param  array  $data
	 * @return obj
	 */
	public function fillNewsObject($object, array $data)
	{
		if(isset($data['title']))
		{
			$object->title = $data['title'];
		}

		if(isset($data['content']))
		{
			$object->content = $data['content'];
		}

		if(isset($data['active']))
		{
			$object->active = $data['active'];
		}

		if(isset($data['image']))
		{
			$object->image = $data['image'];
		}

		return $object;
	}
}