<?php

namespace App\Interfaces;

interface UserRepositoryInterface {

	/**
	 * Get All Users
	 * 
	 * @return mixed
	 */
	public function getAllUsers();

	/**
	 * Get Single User
	 *
	 * @param  $id
	 * @return mixed
	 */
	public function getUser($id);

	/**
	 * Create User
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function createUser(array $data);

	/**
	 * Edit User
	 *
	 * @param  $id
	 * @param  array $data
	 * @return mixed
	 */
	public function editUser($id, array $data);

	/**
	 * Delete User
	 *
	 * @param  $id
	 * @return mixed
	 */
	public function deleteUser($id);

}