<?php

namespace App\Interfaces;

interface TutorRepositoryInterface {

	/**
	 * get all tutors
	 * 
	 * @return mixed
	 */
	public function getTutors();

	/**
	 * create new tutor
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function postTutor(array $data);

	/**
	 * edit tutor
	 *
	 * @param int $id
	 * @param array $data
	 * @return mixed
	 */
	public function updateTutor($id, array $data);

	/**
	 * delete tutor
	 *
	 * @param  int $id
	 * @return mixed
	 */
	public function deleteTutor($id);
}