<?php

namespace App\Interfaces;

interface TestimonialRepositoryInterface {

		/**
	 * Get testimonials
	 * 
	 * @return view
	 */
	public function getTestimonials();

	/**
	 * Create testimonial
	 *
	 * @param  array $data
	 * @return view
	 */
	public function postTestimonial(array $data);

	/**
	 * Update testimonial
	 *
	 * @param  int $id
	 * @param  array $data
	 * @return view
	 */
	public function updateTestimonial($id, array $data);

	/**
	 * Delete testimonial
	 * 
	 * @param  int $id
	 * @return view
	 */
	public function deleteTestimonial($id);

}