<?php 

namespace App\Interfaces;

interface SchoolRepositoryInterface {

	/**
	 * get schools
	 */
	public function getSchools();

	public function getK5schools();
	public function getMiddle68schools();
	public function getHighschools();
	
	/**
	 * create school
	 * @param array $data
	 */
	public function postSchool(array $data);

	/**
	 * Edit school
	 * @param  int $id
	 */
	public function editSchool($id);

	/**
	 * Update school
	 * @param array $data
	 */
	public function updateSchool($id, array $data);

	/**
	 * delete school
	 * @param  int $id
	 */
	public function deleteSchool($id);

}