<?php

namespace App\Interfaces;

interface ProgramRepositoryInterface {

	/**
	 * Get programs
	 * 
	 * @return mixed
	 */
	public function getPrograms();

	/**
	 * Get program
	 *
	 * @var  int $id
	 * @return mixed
	 */
	public function getProgram($id);

	/**
	 * Post programs
	 * 
	 * @param  array  $data
	 * @return mixed
	 */
	public function postProgram(array $data);

	/**
	 * Edit program
	 * 
	 * @param int $id
	 * @param arrat $data
	 * @return mixed
	 */
	public function editProgram($id, array $data);

	/**
	 * Delete program
	 * 
	 * @param int $id
	 * @return mixed
	 */
	public function deleteProgram($id);


}