<?php 

namespace App\Interfaces;

interface NewsRepositoryInterface {

	/**
	 * Get news
	 * 
	 * @return mixed
	 */
	public function getNews();

	/**
	 * Create news
	 *
	 * @param  array $data
	 * @return mixed
	 */
	public function postNews(array $data);

	/**
	 * Edit news
	 * 
	 * @return mixed
	 */
	public function editNews($id, array $data);

	/**
	 * Delete mixed
	 *
	 * @param  int $id
	 * @return view
	 */
	public function deleteNews($id);
}