<?php

// Index
get('/', 'HomeController@index');

// Token
get('/token', function()
{
	return csrf_token();
});

get('/fail', function()
{
	return view('fail');
});

get('/sendMail', 'PaymentController@sendMail');

// Authorize.net
get('/payment', 'PaymentController@index');
post('/payment', 'PaymentController@postPayment');
get('/registration/confirm/{code}', 'PaymentController@activateUser');
get('/enroll', 'PaymentController@enroll');

// Auth
get('/login', 'HomeController@getLogin');
post('/login', 'HomeController@postLogin');
get('/logout', 'HomeController@getLogout');
get('/register', 'HomeController@getRegister');
post('/register/schoolChange', 'HomeController@schoolChange');
// post('/register', 'HomeController@postRegister');

// Front pages
get('/home', 'HomeController@index');
get('/tutors', 'HomeController@tutors');
get('/services', 'HomeController@services');
get('/programs', 'HomeController@programs');
get('/products', 'HomeController@products');
get('/testimonials', 'HomeController@testimonials');
get('/aboutus', 'HomeController@aboutus');
get('/aboutus/sendmail', 'HomeController@aboutus');
get('/search', 'HomeController@search');

//Services
Route::group(['prefix' => 'services'], function(){
	get('/k5', 'ServiceController@k5');
	get('/grades6-8', 'ServiceController@grades68');
	get('/High-School', 'ServiceController@hs');
});

// Program schedules
post('/programs/programSchedule', 'ProgramController@getProgramSchedule');

// Individual Test
Route::group(['prefix' => 'Individual-Test'], function(){
	get('/SAT', function(){ return view('IndividualTest.SAT'); });
	get('/ACT', function(){ return view('IndividualTest.ACT'); });
	get('/SAT_Subject_Tests', function(){ return view('IndividualTest.SATst'); });
	get('/High_School_Subjects', function(){ return view('IndividualTest.HSs'); });
	get('/High_School_State_Exams', function(){ return view('IndividualTest.HSse'); });
	get('/High_School_AP', function(){ return view('IndividualTest.HSap'); });
	get('/Admissions_Consulting', function(){ return view('IndividualTest.AdmCons'); });
	get('/Online_Learning', function(){ return view('IndividualTest.OnLearn'); });

	get('/SHSAT', function(){ 
		$tutors = App\Tutor::all();
		return view('IndividualTest.SHSAT', compact('tutors')); 
	});
	get('/68SchoolSubjects', function(){ return view('IndividualTest.68SchoolSubjects'); });
	get('/68SSAT', function(){ return view('IndividualTest.68SSAT'); });
	get('/68StateExams', function(){ return view('IndividualTest.68StateExams'); });
	get('/68AdmissionsConsulting', function(){ return view('IndividualTest.68AdmissionsConsulting'); });
	get('/68OnlineLearning', function(){ return view('IndividualTest.68OnlineLearning'); });

	get('/ISEE_Lower_Level', function(){ return view('IndividualTest.ISEE_Lower_Level'); });
	get('/SSAT_Lower_level', function(){ return view('IndividualTest.SSAT_Lower_Level'); });
	get('/K5_School_Subjects', function(){ return view('IndividualTest.K5_School_Subjects'); });
	get('/K5_State_Exams', function(){ return view('IndividualTest.K5_State_Exams'); });
	get('/K5_Admissions_Consulting', function(){ return view('IndividualTest.K5_Admissions_Consulting'); });
	get('/K5_Online_Learning', function(){ return view('IndividualTest.K5_Online_Learning'); });
});

// Programs 
Route::group(['prefix' => 'programs'], function(){
	get('/SAT', 'ProgramController@sat');
	get('/SAT-Subject-Tests', 'ProgramController@satTest');
	get('/ACT', 'ProgramController@act');
	get('/PSAT', 'ProgramController@psat');
	get('/SHSAT', 'ProgramController@shsat');
	get('/SSAT', 'ProgramController@ssat');
	get('/ISEE', 'ProgramController@isee');
	get('/state-exams', 'ProgramController@se');
	get('/writing-workshop', 'ProgramController@ww');
	get('/summer-sessions', 'ProgramController@ss');
	get('/High-School-Admissions', 'ProgramController@hsa');
	get('/CA', 'ProgramController@ca');
});

// Profiles
get('/tutor/profile/{id}', 'HomeController@profile');

// Backend
Route::group(['prefix' => 'ivykey'], function(){

	// Dashboard
	get('/dashboard', 'DashboardController@index');
	get('/dashboard/logout', 'DashboardController@getLogout');
	get('/dashboard/classroom', 'DashboardController@classroom');
	get('/dashboard/calendar', 'DashboardController@calendar');
	get('/dashboard/notes', 'DashboardController@notes');
	get('/dashboard/notes/addNote', 'NotesController@getNewNote');
	post('/dashboard/notes/addNote', 'NotesController@addNote');
	post('/dashboard/notes/moveNote', 'NotesController@moveNote');
	post('/dashboard/notes/deleteNote', 'NotesController@deleteNote');
	get('/dashboard/support', 'DashboardController@support');

	// Users
	get('/users', 'UserController@getAllUsers');
	get('/users/{id}', 'UserController@getUser');
	post('/users', 'UserController@createUser');
	put('/users', 'UserController@editUser');
	delete('/users/{id}', 'UserController@deleteUser');

	// Classroom
	get('/dashboard/classroom/checkClassroomStatus', 'ClassroomController@checkClassroomStatus');
	get('/dashboard/classroom/joinClassroom', 'ClassroomController@joinClassroom');

	// Messages
	get('/dashboard/messages', 'MessagesController@index');
	get('/dashboard/messages/inbox', 'MessagesController@inbox');
	get('/dashboard/messages/outbox', 'MessagesController@outbox');

	
});

// CMS
Route::group(['prefix' => 'cms'],function(){
	get('/', 'CMSController@index');

	//tutors
	get('/tutors', 'TutorController@getTutors');
	get('/tutors/add-tutor', 'TutorController@addTutor');
	get('/tutors/edit/{id}', 'TutorController@editTutor');
	post('/tutors', 'TutorController@postTutor');
	post('/tutors/toggleActiveTutor', 'TutorController@toggleActiveTutor');
	put('/tutors', 'TutorController@updateTutor');
	delete('/tutors/{id}', 'TutorController@deleteTutor');
	
	//testimonials
	get('/testimonials', 'TestimonialController@getTestimonials');
	get('/testimonials/add-testimonial', 'TestimonialController@addTestimonial');
	get('/testimonials/edit/{id}', 'TestimonialController@editTestimonial');
	post('/testimonials', 'TestimonialController@postTestimonial');
	post('/testimonials/toggleActiveTestimonial', 'TestimonialController@toggleActiveTestimonial');
	put('/testimonials', 'TestimonialController@updateTestimonial');
	delete('/testimonials/{id}', 'TestimonialController@deleteTestimonail');

	//schools
	get('/schools', 'SchoolController@index');
	get('/schools/primaryK5', 'SchoolController@primaryK5');
	get('/schools/middle68', 'SchoolController@middle68');
	get('/schools/highschool', 'SchoolController@highschool');
	get('/schools/add-school', 'SchoolController@addSchool');
	get('/schools/edit/{id}', 'SchoolController@editSchool');
	post('/schools', 'SchoolController@postSchool');
	put('/schools', 'SchoolController@updateSchool');
	delete('/schools/delete/{id}', 'SchoolController@deleteSchool');

	//programs
	get('/programs', 'ProgramController@getPrograms');
	get('/programs/{id}', 'ProgramController@getProgram');
	get('/programs/add-program', 'ProgramController@addProgram');
	post('/programs', 'ProgramController@postProgram');
	post('/programs/toggleEnrollment', 'ProgramController@toggleEnrollment');
	put('/programs', 'ProgramController@editProgram');
	delete('/programs/{id}', 'ProgramController@deleteProgram');

	//news
	get('/news', 'NewsController@getNews');
	get('/news/add-news', 'NewsController@addNews');
	post('/news', 'NewsController@postNews');
	put('/news/{id}', 'NewsController@editNews');
	delete('/news/{id}', 'NewsController@deleteNews');

	//logout from CMS
	get('/logout', 'CMSController@getLogout');
});

//Administration
Route::group(['prefix' => 'admin'], function()
{
	get('/administration', 'AdministrationController@index');
	get('/administration/manage-users', 'AdministrationController@manageUsers');
	get('/administration/manage-students', 'AdministrationController@manageStudents');
	get('/administration/create-classroom', 'ClassroomController@index');
	get('/administration/check-messages', 'AdministrationController@checkMessages');
	post('/administration/create-classroom', 'ClassroomController@createClassroom');

	//courses
	get('/administration/manage-courses', 'CourseController@manageCourses');
	get('/administration/manage-courses/add-course', 'CourseController@addCourse');
	get('/administration/manage-courses/details/{id}', 'CourseController@showCourse');
	post('/administration/manage-courses/add-course', 'CourseController@createCourse');
	delete('/administration/manage-courses/delete-course/{id}', 'CourseController@deleteCourse');

	//groups
	get('/administration/manage-groups', 'GroupController@index');
	get('/administration/manage-groups/details/{id}', 'GroupController@getGroup');
	get('/administration/manage-groups/edit/{id}', 'GroupController@editGroup');
	get('/administration/manage-groups/add-group', 'GroupController@addGroup');
	post('/administration/manage-groups/getStudents', 'GroupController@getStudents');
	post('/administration/manage-groups/add-group', 'GroupController@createGroup');
	post('/administration/manage-groups/addStudent', 'GroupController@addStudent');
	delete('/administration/manage-groups/remove-student', 'GroupController@removeStudent');
	delete('/administration/delete-group/{id}', 'GroupController@deleteGroup');
	
	//students
	get('/administration/manage-students/add-student', 'AdministrationController@addStudent');
	get('/administration/manage-students/edit-student/{id}', 'AdministrationController@editStudent');
	post('/administration/manage-students/create-classroom', 'ClassroomController@createClassroom');
	post('/administration/manage-students/toExcel', 'AdministrationController@toExcel');
	post('/administration/manage-students/add-student', 'AdministrationController@createStudent');
	delete('/administration/manage-students/removeClass', 'AdministrationController@removeClass');
	put('/administration/manage-students/update-student', 'AdministrationController@updateStudent');
	delete('/administration/manage-students/delete-student/{id}', 'AdministrationController@deleteStudent');

	//logout
	get('/administration/logout', 'AdministrationController@logout');
	
});
