<?php 

namespace App\Http\Controllers;

use App\Interfaces\TutorRepositoryInterface;
use Illuminate\Http\Request;

class TutorController extends ApiController {

	/**
	 * @var TutorRepositoryInterface
	 */
	private $tutor;

	public function __construct(TutorRepositoryInterface $tutor)
	{
		$this->tutor = $tutor;
	}
	/**
	 * Get all tutors
	 * 
	 * @return view
	 */
	public function getTutors()
	{
		$tutors = $this->tutor->getTutors();

		return view('cms.tutors', compact('tutors'));
	}

	public function addTutor()
	{
		return view('cms.add-tutor');
	}

	/**
	 * Create new tutor
	 * 
	 * @return view
	 */
	public function postTutor(Request $request)
	{
		$data = [
			'username' => $request->input('username'),
			'password' => bcrypt($request->input('password')),
			'first_name' => $request->input('first_name'),
			'last_name' => $request->input('last_name'),
			'email' => $request->input('email'),
			'position' => $request->input('position'),
			'location' => $request->input('location'),
			'university' => $request->input('university'),
			'subject' => $request->input('subject'),
			'about' => $request->input('about'),
			'photoURL' => $request->file('tutorPhoto')
		];

		if($request->hasFile('tutorPhoto'))
		{
			$fileName = $request->file('tutorPhoto')->getClientOriginalName();
			$destPath = public_path() . '/images/users/';
			$image = $request->file('tutorPhoto');
			$image->move($destPath, $fileName);
			
		}

		$tutor = $this->tutor->postTutor($data);

		if($tutor)
		{
			return redirect('cms/tutors');
		}

		return back()->with('message', 'Error creating tutor.');

	}

	/**
	 * Edit tutor
	 *
	 * @param  int $id
	 * @return view
	 */
	public function editTutor($id)
	{

		$tutor = $this->tutor->editTutor($id);

		return view('cms.tutor', compact('tutor'));
	}

	/**
	 * Update tutor
	 * 
	 * @param  Request $request
	 * @return view
	 */
	public function updateTutor(Request $request)
	{
		$data = [
			'username' => $request->input('username'),
			'password' => bcrypt($request->input('password')),
			'first_name' => $request->input('first_name'),
			'last_name' => $request->input('last_name'),
			'email' => $request->input('email'),
			'position' => $request->input('position'),
			'location' => $request->input('location'),
			'university' => $request->input('university'),
			'subject' => $request->input('subject'),
			'about' => $request->input('about'),
			'photoURL' => $request->file('tutorPhoto')->getClientOriginalName(),
		];

		$tutorId = $request->input('id');
		$tutor = $this->tutor->updateTutor($tutorId, $data);

		if($tutor) return;
	}

	/**
	 * Delete tutor
	 * 
	 * @param  int $id
	 * @return view
	 */
	public function deleteTutor($id)
	{
		return view('cms.tutors');
	}

	/**
	 * [toggleActiveTutor]
	 * @return mixed
	 */
	public function toggleActiveTutor()
	{
	    if(! \Request::ajax()) return false;

		$posted = $_POST['id'];
	    $toggle_active = $this->tutor->toggleActiveTutor($posted);

	    return $toggle_active;
	}

}